% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar_geometry.R
\name{estimate_sun_elevation}
\alias{estimate_sun_elevation}
\title{Estimate the sun elevation angle for a known site}
\usage{
estimate_sun_elevation(twilight, rise, lon, lat, interval = c(-12, 2))
}
\arguments{
\item{twilight}{POSIXct vector of twilight times from the calibration period.}

\item{rise}{Logical vector marking whether each event is a sunrise (TRUE) or sunset (FALSE).}

\item{lon, lat}{Numeric longitude and latitude of the calibration site.}

\item{interval}{Numeric length-two vector giving the search interval (in degrees) for the sun elevation.}
}
\value{
Named numeric vector containing the inferred zenith angle (`z1`),
  the sun elevation (`degElevation`), and the objective value.
}
\description{
Uses observed calibration twilights at a known location to learn the
sun elevation angle required by the threshold method. The calculation
minimizes the median absolute difference between observed and predicted
twilights using the NOAA solar equations.
}
