% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_detect_calibration.R
\name{auto_detect_calibration}
\alias{auto_detect_calibration}
\title{Automatically Detect Calibration Period}
\usage{
auto_detect_calibration(
  light_data,
  colony_lat,
  colony_lon,
  threshold = 2,
  min_twilights = 2
)
}
\arguments{
\item{light_data}{A data.frame with columns \code{Date} and \code{Light}}

\item{colony_lat}{Numeric latitude of known calibration location}

\item{colony_lon}{Numeric longitude of known calibration location}

\item{threshold}{Light threshold for twilight detection (default: 2)}

\item{min_twilights}{Minimum number of twilights required (default: 2)}
}
\value{
A list with:
  \item{start}{POSIXct start of calibration period}
  \item{end}{POSIXct end of calibration period}
  \item{twilights}{Number of twilights detected}
  \item{duration_days}{Duration in days}
}
\description{
Automatically detects a suitable calibration period from the beginning of
the light data. This assumes the bird was at a known location (typically
the colony) at the start of deployment.
}
\details{
The function tries calibration periods of different lengths (2, 3, 1, 4, 5
days) and returns the first period that yields sufficient twilights with
both sunrise and sunset events.
}
\examples{
example_file <- gls_example("W086")
light_data <- read_lux_file(example_file)
calib <- auto_detect_calibration(light_data,
                                  colony_lat = 27.85,
                                  colony_lon = -115.17,
                                  threshold = 2,
                                  min_twilights = 4)
print(calib)

}
