% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{formula.gkwreg}
\alias{formula.gkwreg}
\title{Extract Formula from GKw Regression Model}
\usage{
\method{formula}{gkwreg}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
The formula used to fit the model. For multi-part formulas, returns
an object of class \code{"Formula"}.
}
\description{
Extracts the model formula from a fitted Generalized Kumaraswamy regression
model object. Properly handles formulas with up to 5 parts.
}
\examples{
\donttest{
data(GasolineYield)

# Simple formula
fit1 <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
formula(fit1)

# Two-part formula
fit2 <- gkwreg(yield ~ temp | batch, data = GasolineYield, family = "kw")
formula(fit2)

# Five-part formula
fit3 <- gkwreg(yield ~ temp | batch | temp | 1 | 1,
  data = GasolineYield, family = "gkw"
)
formula(fit3)
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{update.gkwreg}}
}
\author{
Lopes, J. E.
}
