% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_epigantt.R
\name{geom_epigantt}
\alias{geom_epigantt}
\title{Epi Gantt Chart: Visualize Epidemiological Time Intervals}
\usage{
geom_epigantt(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings. Must include:
\itemize{
\item \code{y}: Case/patient identifier
\item \code{xmin}: Start date/time of interval
\item \code{xmax}: End date/time of interval
\item Optional: \code{colour} or \code{fill} for different locations/categories
}}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{A \code{ggplot2} stat. Defaults to \code{"identity"}.}

\item{position}{A \code{ggplot2} position. Defaults to \code{"identity"}.}

\item{...}{Other arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.\cr
The following parameters are specific to \code{geom_epigantt}:
\itemize{
\item \code{linewidth}: Set width of bars directly, disables auto-scaling if set.
\item \code{lw_scaling_factor}: Scaling factor for auto-width calculation.
The linewidth is calculated as lw_scaling_factor/number_of_rows (default: 90)
\item \code{lw_min}: Minimum auto-scaled line width cutoff (default: 1)
\item \code{lw_max}: Maximum auto-scaled line width cutoff (default: 8)
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}
}
\value{
A \code{ggplot2} geom layer that can be added to a plot
}
\description{
Creates Epi Gantt charts, which are specialized timeline visualizations used in
outbreak investigations to track potential exposure periods and identify transmission
patterns. They are particularly useful for:
\itemize{
\item Hospital outbreak investigations to visualize patient movements between wards
\item Identifying potential transmission events by showing when cases were in the same location
\item Visualizing common exposure times using overlapping exposure time intervals
}

The chart displays time intervals as horizontal bars, typically with one row per case/patient.
Different colours can be used to represent different locations (e.g., hospital wards) or
exposure types. Additional points or markers can show important events like symptom onset
or test dates.

\code{geom_epigantt()} will adjust the linewidth depending on the number of cases.
}
\examples{
library(dplyr)
library(tidyr)
library(ggplot2)

# Transform hospital outbreak line list to long format
linelist_hospital_outbreak |>
  pivot_longer(
    cols = starts_with("ward"),
    names_to = c(".value", "num"),
    names_pattern = "ward_(name|start_of_stay|end_of_stay)_([0-9]+)",
    values_drop_na = TRUE
  ) -> df_stays_long

linelist_hospital_outbreak |>
  pivot_longer(cols = starts_with("pathogen"), values_to = "date") -> df_detections_long

# Create Epi Gantt chart showing ward stays and test dates
ggplot(df_stays_long) +
  geom_epigantt(aes(y = Patient, xmin = start_of_stay, xmax = end_of_stay, color = name)) +
  geom_point(aes(y = Patient, x = date, shape = "Date of pathogen detection"),
    data = df_detections_long
  ) +
  scale_y_discrete_reverse() +
  theme_bw() +
  theme_mod_legend_bottom()

}
\seealso{
\code{\link[=theme_mod_legend_bottom]{theme_mod_legend_bottom()}}
}
