% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_internals.R
\name{kinship2_align.pedigree}
\alias{kinship2_align.pedigree}
\title{Align a pedigree for plotting}
\usage{
kinship2_align.pedigree(
  ped,
  packed = TRUE,
  width = 10,
  align = TRUE,
  hints = ped$hints
)
}
\arguments{
\item{ped}{A pedigree object or pedigreeList object}

\item{packed}{Logical, if TRUE uses compact packing algorithm (default TRUE)}

\item{width}{Numeric, maximum width of the pedigree plot (default 10)}

\item{align}{Logical or numeric. If TRUE, attempts to align spouses on same level.
If numeric, a vector c(a1, a2) controlling alignment penalties (default TRUE)}

\item{hints}{Optional list with `order` and `spouse` components to guide alignment.
If NULL, kinship2_autohint is called to generate hints}
}
\value{
For a single pedigree, a list containing:
  \item{n}{Vector of counts per generation level}
  \item{nid}{Matrix of subject IDs at each position}
  \item{pos}{Matrix of horizontal positions}
  \item{fam}{Matrix of family indices indicating parent connections}
  \item{spouse}{Matrix indicating spouse connections}
  \item{twins}{Optional matrix indicating twin relationships}
  For a pedigreeList, returns the input with alignment information added.
}
\description{
This is the main function for aligning a pedigree structure for plotting.
It arranges subjects by generation, positions them horizontally to minimize
line crossings, handles spouse relationships, and produces the coordinate
system needed for drawing the pedigree.
}
\details{
This function handles the complete pedigree alignment process:
\itemize{
  \item Determines generation levels using kinship2_kindepth
  \item Generates or validates alignment hints using kinship2_autohint or kinship2_check.hint
  \item Builds spouse relationships list
  \item Processes founders and their descendants using kinship2_alignped1, kinship2_alignped2, kinship2_alignped3
  \item Optimizes horizontal spacing using kinship2_alignped4
  \item Identifies inbreeding loops and twin relationships
}
}
\keyword{internal}
