% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_context}
\alias{read_context}
\title{Read files in different contexts}
\usage{
read_context(
  files,
  context,
  .id = "file_id",
  format = NULL,
  parser = NULL,
  ...
)
}
\arguments{
\item{files}{files to reads. Should all be of same format. In many cases,
compressed files (\code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip}) are supported.
Similarly, automatic download of remote files starting with \verb{http(s)://} or
\verb{ftp(s)://} works in most cases.}

\item{context}{the context ("seqs", "feats", "links") in which a given format
should be read.}

\item{.id}{the column with the name of the file a record was read from.
Defaults to "file_id". Set to "bin_id" if every file represents a different
bin.}

\item{format}{specify a format known to gggenomes, such as \code{gff3}, \code{gbk}, ...
to overwrite automatic determination based on the file extension (see
\code{\link[=def_formats]{def_formats()}} for full list).}

\item{parser}{specify the name of an R function to overwrite automatic
determination based on format, e.g. \code{parser="read_tsv"}.}

\item{...}{additional arguments passed on to the format-specific read
function called down the line.}
}
\value{
a tibble with the combined data from all files
}
\description{
Powers \code{\link[=read_seqs]{read_seqs()}}, \code{\link[=read_feats]{read_feats()}}, \code{\link[=read_links]{read_links()}}
}
\section{Functions}{
\itemize{
\item \code{read_context()}: bla keywords internal

}}
