% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodge-nested.R
\docType{data}
\name{position_dodge_nested}
\alias{position_dodge_nested}
\alias{position_dodge_dodge}
\alias{position_dodge_identity}
\alias{PositionDodgeIdentity}
\alias{position_identity_dodge}
\alias{PositionIdentityDodge}
\alias{PositionDodgeDodge}
\title{Nested dodge positions}
\usage{
position_dodge_dodge(
  width = NULL,
  preserve = "single",
  orientation = "x",
  reverse = FALSE
)

position_dodge_identity(
  width = NULL,
  preserve = "single",
  orientation = "x",
  reverse = FALSE
)

position_identity_dodge(
  width = NULL,
  preserve = "single",
  orientation = "x",
  reverse = FALSE
)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements
at a position, or the width of a \code{"single"} element?}

\item{orientation}{Fallback orientation when the layer or the data does not
indicate an explicit orientation, like \code{geom_point()}. Can be \code{"x"}
(default) or \code{"y"}.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}
}
\value{
A ggplot2 position
}
\description{
These functions use nested positioning for distributional data, where one of 
the positions is dodged. This allows you to set different position 
adjustments for the "main" and "distribution" parts of your plot.
}
\examples{
library(ggplot2)

# ggplot dodge 
ggplot(mpg, aes(class)) + 
  geom_bar(aes(fill = drv), 
           position = position_dodge(preserve = "single"))
           
# normal dodge without nesting
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "dodge")
  
# dodge_identity
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "dodge_identity", alpha=0.2)

# dodge_dodge
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "dodge_dodge")

# identity_dodge 
ggplot(mpg, aes(class)) + 
  geom_bar(aes(fill = drv), alpha=0.5, position = "identity")
ggplot(uncertain_mpg, aes(class)) + 
  geom_bar_sample(aes(fill = drv), position = "identity_dodge", alpha=0.7)
  
}
\keyword{datasets}
\section{Aesthetics}{

\code{position_dodge()} understands the following aesthetics. Required aesthetics are displayed in bold and defaults are displayed for optional aesthetics:
\tabular{rll}{
 • \tab \code{order} \tab → \code{NULL} \cr
}

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}
