% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-vegetation-indices.R
\name{calculate_vegetation_index}
\alias{calculate_vegetation_index}
\title{Calculate comprehensive vegetation indices}
\usage{
calculate_vegetation_index(
  spectral_data = NULL,
  red = NULL,
  nir = NULL,
  blue = NULL,
  green = NULL,
  swir1 = NULL,
  swir2 = NULL,
  red_edge = NULL,
  coastal = NULL,
  nir2 = NULL,
  index_type = "NDVI",
  auto_detect_bands = FALSE,
  band_names = NULL,
  clamp_range = NULL,
  mask_invalid = TRUE,
  scale_factor = 1,
  auto_crs_fix = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{spectral_data}{Either individual bands (red, nir, etc.), a multi-band raster,
directory path, or list of raster files}

\item{red}{Red band SpatRaster or file path}

\item{nir}{NIR band SpatRaster or file path}

\item{blue}{Optional blue band}

\item{green}{Optional green band}

\item{swir1}{Optional SWIR1 band}

\item{swir2}{Optional SWIR2 band}

\item{red_edge}{Optional Red Edge band}

\item{coastal}{Optional Coastal/Aerosol band}

\item{nir2}{Optional second NIR band}

\item{index_type}{Vegetation index to calculate (see list_vegetation_indices())}

\item{auto_detect_bands}{Automatically detect bands from multi-band raster}

\item{band_names}{Custom band names for multi-band input}

\item{clamp_range}{Range to clamp output values (optional)}

\item{mask_invalid}{Mask invalid/extreme values}

\item{scale_factor}{Scaling factor if needed (default: 1)}

\item{auto_crs_fix}{Automatically fix CRS mismatches between bands}

\item{verbose}{Print progress messages}
}
\value{
SpatRaster of vegetation index
}
\description{
Calculate a wide range of vegetation indices from spectral bands with
automatic band detection, comprehensive error handling, and validation.
Supports 40+ different vegetation indices for various applications.
Accepts directories, file lists, and automatic CRS handling.
}
\details{
\subsection{Input Format Support:}{
\subsection{Single Calculation:}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Individual band files
ndvi <- calculate_vegetation_index(red = "red.tif", nir = "nir.tif", index_type = "NDVI")

# Multi-band raster
evi <- calculate_vegetation_index(spectral_data = "landsat.tif", index_type = "EVI",
                                 auto_detect_bands = TRUE)
}\if{html}{\out{</div>}}
}

\subsection{Directory/Multiple Files:}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Directory with band files
savi <- calculate_vegetation_index(spectral_data = "/path/to/bands/",
                                  band_names = c("red", "nir"), index_type = "SAVI")

# File list
arvi <- calculate_vegetation_index(spectral_data = c("red.tif", "nir.tif", "blue.tif"),
                                  index_type = "ARVI")
}\if{html}{\out{</div>}}
}

}

\subsection{Enhanced vs Basic NDVI:}{
\subsection{Basic \code{calculate_vegetation_index()}:}{
\itemize{
\item Single time point calculation
\item 40+ different indices
\item Directory/file support
\item Automatic CRS fixing
\item \strong{Use for}: Single-date analysis, comparing different indices
}
}

\subsection{\code{calculate_ndvi_enhanced()}:}{
\itemize{
\item Time series support
\item Quality filtering
\item Temporal smoothing
\item Date matching between red/NIR
\item \strong{Use for}: Multi-temporal analysis, time series trends
}

#' ## Band Naming Conventions:

The function supports case-insensitive band detection:
\itemize{
\item \strong{Generic names}: "red"/"RED"/"Red", "nir"/"NIR", "blue"/"BLUE", "green"/"GREEN"
\item \strong{Landsat 8/9}: B1-B7 (e.g., B4=Red, B5=NIR)
\item \strong{Sentinel-2}: B01-B12 (e.g., B04=Red, B08=NIR, B05=RedEdge)
\item \strong{MODIS}: band1-band7
}
}

\subsection{Satellite-Specific Examples:}{

\strong{Landsat 8/9:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Bands automatically detected
ndvi <- calculate_vegetation_index(
  spectral_data = "LC08_stack.tif",  # Has bands named B1-B7
  index_type = "NDVI",
  auto_detect_bands = TRUE
)
}\if{html}{\out{</div>}}

\strong{Sentinel-2:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Red Edge indices need Sentinel-2
ndre <- calculate_vegetation_index(
  spectral_data = sentinel_data,  # Has B01-B12
  index_type = "NDRE",
  auto_detect_bands = TRUE
)
}\if{html}{\out{</div>}}

\strong{Custom band names:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Rename your bands first
names(my_raster) <- c("red", "nir", "blue", "green")

# Or specify explicitly
ndvi <- calculate_vegetation_index(
  red = my_raster[[1]],
  nir = my_raster[[4]],
  index_type = "NDVI"
)
}\if{html}{\out{</div>}}

For complete band naming documentation, see:
\code{vignette("vegetation-indices", package = "geospatialsuite")}
}

}
}
\examples{
\dontrun{
# These examples require satellite imagery files (Landsat/Sentinel data etc.)
# Basic NDVI calculation
ndvi <- calculate_vegetation_index(red = red_band, nir = nir_band, index_type = "NDVI")

# Multi-band raster with auto-detection
evi <- calculate_vegetation_index(spectral_data = landsat_stack,
                                 index_type = "EVI", auto_detect_bands = TRUE)

# Directory with automatic band detection
savi <- calculate_vegetation_index(spectral_data = "/path/to/sentinel/bands/",
                                  index_type = "SAVI", auto_detect_bands = TRUE)

# Advanced index with custom parameters
pri <- calculate_vegetation_index(red = red_band, nir = nir_band, green = green_band,
                                 index_type = "PRI", clamp_range = c(-1, 1))

# Custom band names for multi-band data
ndvi <- calculate_vegetation_index(spectral_data = sentinel_data,
                                  band_names = c("B4", "B3", "B2", "B8"),
                                  index_type = "NDVI")
}

}
