% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d2_calcs.R
\name{d2_integral}
\alias{d2_integral}
\alias{c4}
\alias{d2_minitab_df}
\title{d2 and c4 Constants for Gage R&R}
\usage{
d2_integral(m, rel.tol = .Machine$double.eps^0.5)

c4(n)

d2_minitab_df(m, g)
}
\arguments{
\item{m}{Integer. Subgroup size (must be \eqn{\ge 2}).}

\item{rel.tol}{Relative tolerance for integration (passed to \code{integrate()}).}

\item{n}{Integer. Degrees of freedom argument for \code{c4}.}

\item{g}{Integer. Number of subgroups (must be \eqn{\ge 1}).}
}
\value{
\itemize{
\item \code{d2_integral()} returns a numeric scalar (expected range for subgroup size \code{m}).
\item \code{c4()} returns a numeric scalar (bias correction factor).
\item \code{d2_minitab_df()} returns a numeric scalar (adjusted constant).
}
}
\description{
Functions to calculate the \eqn{d_2} constant (expected range of a normal subgroup),
the chi-square bias correction factor \eqn{c_4}, and a Minitab-style adjusted
\eqn{d_2} that incorporates the number of subgroups.
}
\details{
\itemize{
\item \code{d2_integral(m)} computes the exact \eqn{d_2(m)} by numerical integration.
\item \code{c4(n)} computes the chi-square bias correction factor \eqn{c_4(n)}.
\item \code{d2_minitab_df(m, g)} computes a finite-sample adjusted constant
\eqn{d_2^{adj}(m,g) = d_2(m) / c_4(df)}, with
\eqn{df = g \times (m-1)} degrees of freedom, consistent with Minitab/AIAG tables.
}
}
\examples{
# Exact d2 for subgroup size 5
d2_integral(5)

# Chi-square bias correction for df = 8
c4(8)

# Minitab-style adjusted constant for m = 5, g = 2
d2_minitab_df(5, 2)

}
\seealso{
\code{\link{integrate}}, \code{\link{gamma}}
}
