% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{africa_segments}
\alias{africa_segments}
\title{Raw Network Segments for Trans-African Transport Network}
\format{
A data frame with 14,358 rows and 7 columns:
\describe{
  \item{FX}{Numeric. Start point longitude (range: -17.4 to 49.2).}
  \item{FY}{Numeric. Start point latitude (range: -34.2 to 37.2).}
  \item{TX}{Numeric. End point longitude (range: -17.0 to 49.1).}
  \item{TY}{Numeric. End point latitude (range: -34.2 to 37.2).}
  \item{passes}{Integer. Number of optimal inter-city routes passing through this segment.
    Range: 1 to 1,615, median: 46.}
  \item{gravity}{Numeric. Sum of population gravity weights from routes using this segment.
    Computed as sum of (pop_origin * pop_destination / spherical_distance_km) / 1e9.}
  \item{gravity_rd}{Numeric. Sum of road-distance-weighted gravity from routes.
    Computed as sum of (pop_origin * pop_destination / road_distance_m) / 1e9.}
}
}
\source{
Derived from OpenStreetMap routing data via OSRM, processed through route intersection
and aggregation.

Dataset constructed for: Krantz, S. (2024). Optimal Investments in Africa's Road Network.
Policy Research Working Paper 10893. World Bank. \doi{10.1596/1813-9450-10893}.
Replication materials: \url{https://github.com/SebKrantz/OptimalAfricanRoads}.
}
\usage{
data(africa_segments)
}
\description{
A dataset containing 14,358 raw network segments representing intersected road routes
between African cities. Each segment is defined by start and end coordinates with
aggregate importance metrics. This dataset is provided to demonstrate how package
functions like \code{\link[=consolidate_graph]{consolidate_graph()}} and
\code{\link[=simplify_network]{simplify_network()}} can process messy segment data
into clean analytical networks like \code{\link{africa_network}}.
}
\details{
This dataset represents an intermediate stage in network construction, after routes have been
intersected but before network simplification. The segments have been simplified using
\code{\link[=linestrings_from_graph]{linestrings_from_graph()}} to retain only start and end coordinates.

The segments can be used to demonstrate the flownet network processing workflow:
\enumerate{
  \item Convert segments to an sf LINESTRING object using \code{\link[=linestrings_from_graph]{linestrings_from_graph()}}
  \item Apply \code{\link[=consolidate_graph]{consolidate_graph()}} to merge nearby nodes
  \item Apply \code{\link[=simplify_network]{simplify_network()}} to remove intermediate nodes
}

The \code{passes} field indicates how many optimal city-to-city routes use each segment,
serving as a measure of segment importance in the network. Higher values indicate
segments that are critical for efficient inter-city connectivity.
}
\examples{
data(africa_segments)
head(africa_segments)

# Summary statistics
summary(africa_segments[, c("passes", "gravity", "gravity_rd")])

# Segments with highest traffic
africa_segments[order(-africa_segments$passes), ][1:10, ]

\donttest{
# Convert to sf and plot
library(sf)
segments_sf <- linestrings_from_graph(africa_segments)
plot(segments_sf["passes"])
}

}
\seealso{
\code{\link{africa_network}}, \code{\link[=consolidate_graph]{consolidate_graph()}},
  \code{\link[=simplify_network]{simplify_network()}}, \code{\link[=linestrings_from_graph]{linestrings_from_graph()}},
  \link{flownet-package}
}
\keyword{datasets}
