% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_top_concepts.R
\name{get_top_concepts}
\alias{get_top_concepts}
\title{Get top concepts of a specific vocabulary from the Finto Skosmos API}
\usage{
get_top_concepts(vocid, lang = NULL, scheme = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{lang}{The language of labels to retrieve, e.g., "en" or "fi". Optional.}

\item{scheme}{The concept scheme to retrieve top concepts from. Optional.}
}
\value{
A tibble containing the URI, label, topConceptOf, notation, and hasChildren for each top concept.
}
\description{
Get top concepts of a specific vocabulary from the Finto Skosmos API
}
\examples{
result <- get_top_concepts(vocid = "yso", lang = "fi")
print(result)
}
