% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{A_DataR}
\alias{A_DataR}
\title{Amputee Right-Side Gait Data}
\format{
A list containing the 9 kinematic variables with each list containing a data.frame with N rows and T variables, where N is 
the total number of subjects and T is the total number of time points. 
\describe{
  \item{Right Pelvis Angles D2}{numeric data.frame with N rows and T variables}
  \item{Right Pelvis Angles D1}{numeric data.frame with N rows and T variables}
  \item{Right Pelvis Angles D3}{numeric data.frame with N rows and T variables}
  \item{Right Hip Angles D2}{numeric data.frame with N rows and T variables}
  \item{Right Hip Angles D1}{numeric data.frame with N rows and T variables}
  \item{Right Hip Angles D3}{numeric data.frame with N rows and T variables}
  \item{Right Knee Angles}{numeric data.frame with N rows and T variables}
  \item{Right Ankle Angle}{numeric data.frame with N rows and T variables}
  \item{Right Foot Progression Angle}{numeric data.frame with N rows and T variables}
}
 @examples
# Load the Data
data(A_DataR)
}
\usage{
A_DataR
}
\description{
Kinematic data for 18 individuals with right-side above-knee amputations and 42 healthy controls.
Includes pelvic, hip, knee, ankle, and foot angles, sampled at 1% intervals
over the full gait cycle. Amputee data from Hood et al. (2020); control data from Fukuchi et al. (2018).
}
\keyword{datasets}
