% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-gmle.R
\name{fit_gmle}
\alias{fit_gmle}
\title{Generalized Maximum Likelihood Parameter Estimation}
\usage{
fit_gmle(data, prior, ns_years = NULL, ns_structure = NULL)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{prior}{Numeric vector of length 2. Specifies the parameters of the
Beta prior for the shape parameter \eqn{\kappa}.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
A list containing the results of parameter estimation:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{prior}: The \code{prior} argument.
\item \code{ns_years}: The \code{ns_years} argument, if given.
\item \code{ns_structure}: The \code{ns_structure} argument, if given.
\item \code{method}: \code{"GMLE"}.
\item \code{params}: Numeric vector of estimated parameters.
\item \code{mll}: The maximum value of the generalized log‐likelihood.
}
}
\description{
Estimates the parameters of the generalized extreme value (GEV) distribution by
maximizing the generalized log‐likelihood, which incorporates a Beta prior on the
shape parameter. Initial parameter estimates are obtained using the method of L‐moments
and optimization is performed via \code{\link[stats:nlminb]{stats::nlminb()}} with repeated perturbations if
needed.

\strong{For NS-FFA}: To estimate parameters for a nonstationary model, include the
observation years (\code{ns_years}) and the nonstationary model structure (\code{ns_structure}).
}
\details{
\enumerate{
\item Calls \code{\link[=fit_lmoments]{fit_lmoments()}} on the data to obtain initial parameter estimates.
\item Initializes trend parameters to zero if necessary.
\item Defines an objective function using \code{\link[=utils_generalized_likelihood]{utils_generalized_likelihood()}}.
\item Runs \code{\link[stats:nlminb]{stats::nlminb()}} with box constraints. Attempts minimization up to 100 times.
}
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
prior <- c(6, 9)
ns_years <- seq(from = 1901, to = 2000)
ns_structure <- list(location = TRUE, scale = FALSE)
fit_gmle(data, prior, ns_years, ns_structure)

}
\references{
El Adlouni, S., Ouarda, T.B.M.J., Zhang, X., Roy, R., Bobee, B., 2007. Generalized
maximum likelihood estimators for the nonstationary generalized extreme value
model. Water Resources Research 43 (3), 1–13. \doi{10.1029/2005WR004545}

Martins, E. S., and Stedinger, J. R. (2000). Generalized maximum-likelihood generalized
extreme-value quantile estimators for hydrologic data. Water Resources Research, 36(3),
737–744. \doi{10.1029/1999WR900330}
}
\seealso{
\code{\link[=utils_generalized_likelihood]{utils_generalized_likelihood()}}, \code{\link[=fit_lmoments]{fit_lmoments()}}, \code{\link[stats:nlminb]{stats::nlminb()}}
}
