% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{felt_add_map_layers}
\alias{felt_add_map_layers}
\title{Add Layers to Existing Map}
\usage{
felt_add_map_layers(
  map_id,
  name = NULL,
  file_names = NULL,
  lat = NULL,
  lng = NULL,
  zoom = NULL,
  clean = TRUE
)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{name}{Name of the layer. Required.}

\item{file_names}{Files to include. Required.}

\item{lat}{For images, the latitude of the center of the image. Optional.}

\item{lng}{For images, the longitude of the center of the image. Optional.}

\item{zoom}{For images, the zoom level of the image. Optional.}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}
}
\value{
status of the upload
}
\description{
Add Layers to Existing Map
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
layer <- felt_add_map_layers(map_id = 'Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA',
                    file_names = fs::path_package('feltr',  'towns.geojson'),
                    name = 'Towns  test')
layer
\dontshow{\}) # examplesIf}
}
\concept{edits}
