% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_fauna.R
\name{subset_fauna}
\alias{subset_fauna}
\title{Extract a subset of species from Fauna do Brasil database}
\usage{
subset_fauna(data, species, include_subspecies = FALSE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function.}

\item{species}{(character) names of the species to be extracted from Fauna do
Brasil database.}

\item{include_subspecies}{(logical) include subspecies? Default = FALSE}
}
\value{
A data.frame with the selected species.
}
\description{
Returns a data.frame with a subset of species from Fauna do Brasil database
}
\examples{
data("fauna_data") #Load data example
#Species to extract from database
spp <- c("Panthera onca", "Mazama jucunda", "Subulo gouzoubira")
spp_subset <- subset_fauna(data = fauna_data, species = spp,
                      include_subspecies = FALSE)
spp_subset
}
