% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_stability.R
\name{explain_stability}
\alias{explain_stability}
\title{Analyze Feature Importance Stability Across Cross-Validation Folds}
\usage{
explain_stability(
  object,
  model_name = NULL,
  vi_iterations = 10,
  seed = 123,
  plot = TRUE,
  conf_level = 0.95
)
}
\arguments{
\item{object}{A \code{fastml} object trained with \code{store_fold_models = TRUE}.}

\item{model_name}{Character string specifying which model to analyze. If NULL,
uses the best model. Should match the format "algorithm (engine)", e.g.,
"rand_forest (ranger)".}

\item{vi_iterations}{Integer. Number of permutations for variable importance
per fold. Default is 10 for faster computation across many folds.}

\item{seed}{Integer. Random seed for reproducibility.}

\item{plot}{Logical. If TRUE (default), displays a stability plot showing
mean importance with confidence intervals.}

\item{conf_level}{Numeric. Confidence level for intervals. Default is 0.95.}
}
\value{
A list with class \code{"fastml_stability"} containing:
  \describe{
    \item{importance_summary}{Data frame with aggregated feature importance
      (mean, sd, se, lower/upper CI) across folds.}
    \item{fold_importance}{List of per-fold variable importance results.}
    \item{rank_stability}{Data frame showing how feature ranks vary across folds.}
    \item{n_folds}{Number of folds analyzed.}
    \item{model_name}{Name of the model analyzed.}
  }
}
\description{
Computes feature importance for each fold model and aggregates results
to assess the stability of feature importance rankings across resamples.
This helps identify features that are consistently important vs those
whose importance varies across different data subsets.
}
\details{
This function requires that the fastml model was trained with
\code{store_fold_models = TRUE}, which stores the models fitted on each
cross-validation fold. Without stored fold models, only the final best
model is available, and cross-fold stability analysis is not possible.

The stability analysis computes permutation-based variable importance
for each fold's model using DALEX, then aggregates across folds to show:
\itemize{
  \item Mean importance and standard deviation
  \item Confidence intervals for importance
  \item Rank stability (how consistently features rank across folds)
}

Features with high mean importance but also high variance may be
important for some data subsets but not others, suggesting potential
instability in the model's reliance on those features.
}
\examples{
\donttest{
# Train model with fold models stored
model <- fastml(
  data = iris,
  label = "Species",
  algorithms = "rand_forest",
  store_fold_models = TRUE
)

# Analyze stability
stability <- explain_stability(model)
print(stability)
}

}
