% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchar.R
\name{nchar_ctl}
\alias{nchar_ctl}
\alias{nzchar_ctl}
\title{Control Sequence Aware Version of nchar}
\usage{
nchar_ctl(
  x,
  type = "chars",
  allowNA = FALSE,
  keepNA = NA,
  ctl = "all",
  warn = getOption("fansi.warn", TRUE),
  strip
)

nzchar_ctl(
  x,
  keepNA = FALSE,
  ctl = "all",
  warn = getOption("fansi.warn", TRUE)
)
}
\arguments{
\item{x}{a character vector or object that can be coerced to such.}

\item{type}{character(1L) partial matching
\code{c("chars", "width", "graphemes")}.  See \code{\link[base:nchar]{?nchar}}, as well
as the corresponding documentation sections on this page.}

\item{allowNA}{logical: should \code{NA} be returned for invalid
    multibyte strings or \code{"bytes"}-encoded strings (rather than
    throwing an error)?}

\item{keepNA}{logical: should \code{NA} be returned when
  \code{x} is \code{\link[base]{NA}}?  If false, \code{nchar()} returns
  \code{2}, as that is the number of printing characters used when
  strings are written to output, and \code{nzchar()} is \code{TRUE}.  The
  default for \code{nchar()}, \code{NA}, means to use \code{keepNA = TRUE}
  unless \code{type} is \code{"width"}.}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, and OSC hyperlinks, \code{fansi}
will also parse, interpret, and reapply the sequences as needed.  You can
modify whether a \emph{Control Sequence} is treated specially with the \code{ctl}
parameter.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "url": OSC hyperlinks
\item "osc": all non-OSC-hyperlink OSC sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \code{\link[=fansi]{?fansi}}).
At most one warning will be issued per element in each input vector.  Will
also warn about some badly encoded UTF-8 strings, but a lack of UTF-8
warnings is not a guarantee of correct encoding (use \code{\link{validUTF8}} for
that).}

\item{strip}{character, deprecated in favor of \code{ctl}.}
}
\value{
Like \code{\link[base:nchar]{base::nchar}}, with \emph{Control Sequences} excluded.
}
\description{
\code{nchar_ctl} counts all non \emph{Control Sequence} characters.
\code{nzchar_ctl} returns TRUE for each input vector element that has non \emph{Control
Sequence} sequence characters.  By default newlines and other C0 control
characters are not counted.
}
\details{
\code{nchar_ctl} and \code{nzchar_ctl} are implemented in statically compiled code, so
in particular \code{nzchar_ctl} will be much faster than the otherwise equivalent
\code{nzchar(strip_ctl(...))}.

These functions will warn if either malformed or escape or UTF-8 sequences
are encountered as they may be incorrectly interpreted.
}
\note{
The \code{keepNA} parameter is ignored for R < 3.2.2.
}
\section{Control and Special Sequences}{


\emph{Control Sequences} are non-printing characters or sequences of characters.
\emph{Special Sequences} are a subset of the \emph{Control Sequences}, and include CSI
SGR sequences which can be used to change rendered appearance of text, and
OSC hyperlinks.  See \code{\link{fansi}} for details.
}

\section{Output Stability}{


Several factors could affect the exact output produced by \code{fansi}
functions across versions of \code{fansi}, \code{R}, and/or across systems.
\strong{In general it is best not to rely on exact \code{fansi} output, e.g. by
embedding it in tests}.

Width and grapheme calculations depend on Unicode database version (see
\code{\link{fansi_unicode_version}}, and grapheme processing logic among other
things (see "Graphemes").  Individual character width are intended to match
R4.5.1 definitions in an English locale, except for differences introduced by
Unicode Database Version updates and grapheme processing.

How a particular display format is encoded in \emph{Control Sequences} is
not guaranteed to be stable across \code{fansi} versions.  Additionally, which
\emph{Special Sequences} are re-encoded vs transcribed untouched may change.
In general we will strive to keep the rendered appearance stable.

To maximize the odds of getting stable output set \code{normalize_state} to
\code{TRUE} and \code{type} to \code{"chars"} in functions that allow it, and
set \code{term.cap} to a specific set of capabilities.
}

\section{Graphemes}{


\code{fansi} approximates grapheme widths and counts by using heuristics for
grapheme breaks that work for most common graphemes, including emoji
combining sequences.  The heuristic is known to work incorrectly with
invalid combining sequences, prepending marks, and sequence interruptors.
The \href{https://cran.r-project.org/package=utf8}{\code{utf8}} package provides a
conforming grapheme parsing implementation.
}

\examples{
nchar_ctl("\033[31m123\a\r")
## with some wide characters
cn.string <-  sprintf("\033[31m\%s\a\r", "\u4E00\u4E01\u4E03")
nchar_ctl(cn.string)
nchar_ctl(cn.string, type='width')

## Remember newlines are not counted by default
nchar_ctl("\t\n\r")

## The 'c0' value for the `ctl` argument does not include
## newlines.
nchar_ctl("\t\n\r", ctl="c0")
nchar_ctl("\t\n\r", ctl=c("c0", "nl"))

## The _sgr flavor only treats SGR sequences as zero width
nchar_sgr("\033[31m123")
nchar_sgr("\t\n\n123")

## All of the following are Control Sequences or C0 controls
nzchar_ctl("\n\033[42;31m\033[123P\a")
}
\seealso{
\code{\link[=fansi]{?fansi}} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\code{\link{unhandled_ctl}} for detecting bad control sequences.
}
