% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.cellwise.normality.datatable.R
\name{residuals.cellwise.normality.datatable}
\alias{residuals.cellwise.normality.datatable}
\title{Cellwise residual normality (Shapiro–Wilk) from ANOVA models}
\usage{
\method{residuals}{cellwise.normality.datatable}(formula, data, force_factors = TRUE)
}
\arguments{
\item{formula}{A model formula \code{y ~ A + B (+ C ...)}.}

\item{data}{A data frame with the variables.}

\item{force_factors}{Logical; if TRUE, coerces RHS predictors to factors.}
}
\value{
A data.frame with rows per cell across all factor combinations. Columns include:
\code{Effect}, factor columns (with NA for factors not in the current subset),
\code{count}, \code{W}, \code{p.shapiro} (4 decimals), \code{OK}.
}
\description{
Fits, for each subset of RHS factors, a full-factorial ANOVA to the response and
tests Shapiro–Wilk normality of residuals within each cell defined by those factors.
Matches the classical ANOVA assumption of normal errors per cell.
}
\examples{
\dontrun{
residuals.cellwise.normality.datatable(liking ~ gender + condition + age_cat, data = mimicry)
}
}
\seealso{
\code{\link{normality.datatable}}, \code{\link{plan.diagnostics}}
}
