% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology.R
\name{approx_zadoks}
\alias{approx_zadoks}
\title{Approximate Date for a Target Zadoks Stage}
\usage{
approx_zadoks(zadoks, date, target)
}
\arguments{
\item{zadoks}{A numeric vector of Zadoks growth stages (should be between 51 and 69).}

\item{date}{A vector of dates (class \code{Date}) corresponding to each Zadoks stage.}

\item{target}{A single numeric value indicating the target Zadoks stage for which to estimate the date.}
}
\value{
A \code{Date} object representing the interpolated date for the target Zadoks stage, 
or \code{NA} if the target is outside the observed range.
}
\description{
This function estimates the date corresponding to a specified target Zadoks stage
by interpolating between known Zadoks stages and their associated dates.
Phenology Analysis Functions
}
\details{
This module provides methods for analyzing phenological data, particularly focusing on the Zadoks scale.


The following two methods are implemented:

1. **Relative Date for Observed Target (Zadoks Rounded):**
   - If the target phenological stage is observed in the dataset (after rounding Zadoks values), 
the function will use the relative date corresponding to this observation. 
This allows for precise tracking of phenological events based on actual recorded data.

2. **Linear Interpolation for Target within Observed Range:**
   - If the target Zadoks stage is not directly observed but falls within the range of observed stages, 
the function estimates the date using linear interpolation between the nearest observed stages. 
This provides an approximate date for the target stage based on the trend of observed data.
}
\note{
Ensure that the input data includes Zadoks stage observations and corresponding dates for accurate analysis.
}
\examples{
zadoks <- c(51, 54, 55, 59)
date <- as.Date(c("2020-08-15", "2020-08-17", "2020-08-18", "2020-08-21"))
target <- 55
approx_zadoks(zadoks, date, target)
approx_zadoks(zadoks[-3], date[-3], target)

}
