% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mode_na_ignore.R
\name{calc_mode_na_ignore}
\alias{calc_mode_na_ignore}
\title{Calculate mode with optional tie-breaks ignoring NA and empty strings}
\usage{
calc_mode_na_ignore(x, tie_break = NULL, second_tie_break = NULL)
}
\arguments{
\item{x}{A character vector for which to find the mode.}

\item{tie_break}{An optional numeric vector used as the first tie-break criterion.}

\item{second_tie_break}{An optional numeric vector used as the second tie-break criterion when the first is insufficient.}
}
\value{
Returns the mode of `x` ignoring `NA` and empty strings. If the filtered vector is empty or all elements are `NA` or empty, returns `NA`.
}
\description{
This function calculates the mode of a given vector, ignoring `NA` and empty strings, and optionally resolves ties using one or two levels of tie-breaks.
If all values are `NA` or empty, the function returns `NA`.
}
\examples{
data <- c("apple", "", "banana", NA)
tie_break <- c(1, NA, 1, NA)
second_tie_break <- c(1, NA, 2, NA)
calc_mode_na_ignore(data)  # Expect: "apple"
calc_mode_na_ignore(data, tie_break)  # Expect: "banana"
calc_mode_na_ignore(data, tie_break, second_tie_break)  # Expect: "banana"
}
