% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recovery_extent.R
\name{recovery_extent}
\alias{recovery_extent}
\title{Calculate the extent of recovery after disturbance}
\usage{
recovery_extent(
  type,
  response = NULL,
  t_rec,
  summ_mode = "mean",
  b = NULL,
  b_tf = NULL,
  vd_i = NULL,
  td_i = NULL,
  d_data = NULL,
  vb_i = NULL,
  tb_i = NULL,
  b_data = NULL,
  comm_d = NULL,
  comm_b = NULL,
  comm_t = NULL,
  method = "bray",
  binary = "FALSE",
  na_rm = TRUE
)
}
\arguments{
\item{type}{a string defining the type of stability (\code{"functional"} or \code{"compositional"}) to be calculated.}

\item{response}{a string stating whether the stability metric should be
calculated using the log-response ratio between the values in the disturbed
system and the baseline (\code{response = "lrr"}) or using the state
variable values in the disturbed system alone.}

\item{t_rec}{An integer, time point at which the extent of recovery should be
calculated.}

\item{summ_mode}{A string, stating whether the baseline should be summarized as
the mean (\code{summ_mode = "mean"}) or the median (\code{summ_mode = "median"}).
Defaults to "mean".}

\item{b}{a string stating whether the baseline is defined by a separate
baseline that is specified by the user (\code{b = "input"}) or by a
period of the disturbed system (\code{b = "d"}) prior to the disturbance.
This period is specified by \code{b_tf}.}

\item{b_tf}{a numerical vector, specifying the beginning and end of the
pre-disturbance time period for the disturbed time-series that defines
the baseline. Obligatory if (\code{b = "d"}), see 'Details'.}

\item{vd_i}{a numeric vector containing the state variable in the
disturbed system or a string specifying the name of the column
containing said variable in the dataframe provided in \code{d_data}.}

\item{td_i}{a numeric vector containing the time or a string specifying the
name of the column containing the time in the dataframe provided
in \code{d_data}.}

\item{d_data}{an optional data frame containing the time series of the
state variable values in a disturbed system.}

\item{vb_i}{an optional numeric vector containing the state variable in
the baseline, or a string for the name of the column in \code{b_data}
containing said variable in the dataframe with baseline values.}

\item{tb_i}{an optional numeric vector containing the time period over which
the baseline was measured, or a string for the name of the column in
\code{b_data} containing said the time variable in the dataframe
with baseline values.}

\item{b_data}{an optional data frame containing the time series of the
state variable values in the baseline.}

\item{comm_d}{a data frame containing long format community data
(species as columns over time as rows) to calculate compositional metrics.}

\item{comm_b}{a data frame containing long format community data (species
names as columns over time as rows) to calculate compositional metrics.}

\item{comm_t}{the name of the time variable in comm_b and comm_d.}

\item{method}{a string identifying the dissimilarity index to be used to
calculate dissimilarity. For more options, see \code{?vegdist}.
Defaults to "bray".}

\item{binary}{a boolean stating whether presence/absence standardization
should be performed before calculating the dissimilarity. For more options,
see \code{?vegdist}. Defaults to "bray".}

\item{na_rm}{a logical determining whether NAs should be taken out prior
to the estimation of the stability metric. Defaults to TRUE.}
}
\value{
A numeric, the extent of recovery. Maximum (functional and
compositional) recovery at 0. For functional stability, smaller or higher
values indicate under- or overcompensation, respectively. For compositional
stability using the Bray-Curtis index (default),
\eqn{0 \le R_e \le 1}
.
The higher the index, the further apart the communities are after recovery,
and thus, the lower the recovery is.
}
\description{
\code{recovery_extent} ( \eqn{R_e} ) calculates how close a state variable is
to its baseline value at a time point specified by the user
(usually after recovery has taken place). For functional stability,
the  distance can be calculated as the log-response ratio or as the
difference between the state variables in a disturbed
time-series and the baseline. The baseline can be
\itemize{
\item a value at time \code{t_rec} of the baseline time-series
\code{b_data} (if \code{b = "input"}).
\item pre-disturbance values of the state variable in the disturbed system
over a period defined by \code{b_tf} (if \code{b = "d"}). In that case,
the state variable is summarized as the mean or median (\code{summ_mode}).
}
For community stability, the distance is calculated as the dissimilarity
between the disturbed and baseline communities.
}
\details{
For functional stability, the log-response ratio or difference between the
state variable in the disturbed systems
\eqn{v_d}
and in the baseline
( \eqn{v_b} or \eqn{v_p}
if the baseline is pre-disturbance values) measured on the user-defined
time step when the recovery is assumed to have taken place. Therefore,
\eqn{R_e = \log\!\left(\frac{v_d(t)}{v_b(t)}\right)}
, or
\eqn{R_e = \log\!\left(\frac{v_d(t)}{v_p(t)}\right)}
, or
\eqn{R_e = \lvert v_d(t) - v_b(t) \rvert}
, or
\eqn{R_e = \lvert v_d(t) - v_p(t) \rvert}
.

For community stability, the dissimilarity between the disturbed
( \eqn{C_d} )
and baseline
( \eqn{C_b} )
communities
\eqn{R_e = \mathrm{dissim}\!\left(\frac{C_d(t)}{C_b(t)}\right)}
.

Even though it is possible to use a single data value as baseline, it is not
recommended, because a single value does not account for any variability in
the system arising from, for example, demographic or environmental
stochasticity.
}
\examples{
recovery_extent(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps,
  response = "lrr", b = "input", t_rec = 42, vb_i = "statvar_bl",
  tb_i = "time", b_data = aquacomm_resps, type = "functional"
)
recovery_extent(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps,
  response = "diff", b = "input", t_rec = 42, vb_i = "statvar_bl",
  tb_i = "time", b_data = aquacomm_resps, type = "functional"
)
recovery_extent(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps,
  response = "lrr", b = "d", t_rec = 42, b_tf = 8, type = "functional"
)
recovery_extent(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps,
  response = "lrr", b = "d", t_rec = 42, b_tf = c(5, 10), type = "functional"
)
recovery_extent(
  vd_i = "statvar_db", td_i = "time", d_data = aquacomm_resps,
  response = "lrr", type = "functional",
  b = "d", t_rec = 42, b_tf = c(5, 10), summ_mode = "median"
)
recovery_extent(
  type = "compositional", t_rec = 28, comm_d = comm_dist,
  comm_b = comm_base, comm_t = "time"
)
}
