% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matriz.covarianzas.R
\name{matriz.covar}
\alias{matriz.covar}
\title{Matriz de varianzas y covarianzas.}
\usage{
matriz.covar(
  x,
  variable = NULL,
  tipo = c("muestral", "cuasi"),
  exportar = FALSE
)
}
\arguments{
\item{x}{Conjunto de datos. Es un dataframe con al menos 2 variables (2 columnas).}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} solo tiene 2 variables (columnas), \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de las variables a seleccionar.}

\item{tipo}{Es un carácter. Por defecto de calcula la matriz de varianzas y covarianzas muestrales (\code{tipo = "muestral"}). Si \code{tipo = "cuasi"}, se calcula la matriz de cuasi-varianzas y cuasi-covarianzas muestrales.}

\item{exportar}{Para exportar los resultados a una hoja de cálculo Excel (\code{exportar = TRUE}).}
}
\value{
La función devuelve la matriz de varianzas-covarianzas (muestrales, por defecto) de las variables seleccionadas en un \code{data.frame}.
}
\description{
Obtiene la matriz de varianzas y covarianzas.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qrcovarianza.png}{width = 200px}}
\if{latex}{\figure{qrcovarianza.png}{options: width=3cm}}
}
\details{
(1) Se obtiene la matriz de varianzas y covarianzas muestrales:

\if{html}{\figure{matrizvarcovmuestra.png}{width = 400px}}
\if{latex}{\figure{matrizvarcovmuestra.png}{options: width=8cm}}

(2) Muchos manuales y prácticamente todos los softwares (SPSS, Excel, etc.) facilitan la matriz de cuasi-varianzas y cuasi-covarianzas muestrales:

\if{html}{\figure{matrizvarcovcuasi.png}{width = 440px}}
\if{latex}{\figure{matrizvarcovcuasi.png}{options: width=8cm}}

Nosotros nos referimos a esta expresión como cuasi-covarianza muestral.
}
\note{
Si en lugar del tamaño muestral (n) se utiliza el tamaño de la población (N) se obtiene la matriz de varianzas y covarianzas poblacional:

\if{html}{\figure{matrizvarcovpob.png}{width = 440px}}
\if{latex}{\figure{matrizvarcovpob.png}{options: width=8cm}}
}
\examples{

matriz_covarianzas1 <- matriz.covar(startup)
matriz_covarianzas2 <- matriz.covar(startup, tipo= "cuasi")

}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{varianza}}, \code{\link{desviacion}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
