% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.static.sign}
\alias{plot.static.sign}
\title{Visualization for Signed Networks}
\usage{
\method{plot}{static.sign}(
  x,
  col_pos = "#008000",
  col_neg = "#E3000F",
  neg.lty = 1,
  inv_weights = TRUE,
  coord = NULL,
  ...
)
}
\arguments{
\item{x}{A signed network object of class \code{static.sign}.}

\item{col_pos}{Color for positive edges. Default is 'green3'.}

\item{col_neg}{Color for negative edges. Default is 'red3'.}

\item{neg.lty}{Line type for negative edges. Default is "solid". Other options are "dotted" and "dashed".}

\item{inv_weights}{Logical. If TRUE, edge weights are inverted (1/weights) so positive edges pull nodes closer together. Default is TRUE.}

\item{coord}{Optional matrix of coordinates for node positions. If NULL, layout is computed using stress majorization.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
A plot of the signed network.
}
\description{
Functions to visualize signed networks in static or dynamic form.
}
\section{Layout}{

Uses a force-directed graph layout based on stress majorization, implemented in the \code{graphlayouts} package
via \code{layout_with_stress()}. Similar to Kamada-Kawai, but generally faster and with better results.
}

\section{Static signed networks}{

\code{plot.static.sign()} visualizes a single (static) signed network.
}

\examples{
data("tribes")
plot(tribes, col_pos = "green", col_neg = "red")

}
\references{
\insertRef{gansner2004graph}{ergm.sign}
}
\seealso{
\link{UnLayer}, \link[graphlayouts]{layout_with_stress}
}
