% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve.R
\name{zcurve}
\alias{zcurve}
\title{Create a curve comparing observed Z-scores to the WHO standard.}
\usage{
zcurve(x, zscore)
}
\arguments{
\item{x}{a data frame}

\item{zscore}{bare name of a numeric vector containing computed zscores}
}
\value{
a ggplot2 object that is customisable via the ggplot2 package.
}
\description{
Create a curve comparing observed Z-scores to the WHO standard.
}
\examples{
\dontshow{if (requireNamespace("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("ggplot2")
set.seed(9)
dat <- data.frame(observed = rnorm(204) + runif(1),
                  skewed   = rnorm(204) + runif(1, 0.5)
                 ) # slightly skewed
zcurve(dat, observed) +
  labs(title = "Weight-for-Height Z-scores") +
  theme_classic()

zcurve(dat, skewed) +
  labs(title = "Weight-for-Height Z-scores") +
  theme_classic()

# Including different groups to facet
dat <- data.frame(
  observed = c(rnorm(204) + runif(1), rnorm(204) + runif(1, 0.5)),
  groups   = rep(c("A", "B"), each = 204),
  treat    = sample(c('up', 'down'), 408, replace = TRUE)
                 )
zcurve(dat, observed) +
  facet_grid(treat~groups)
\dontshow{\}) # examplesIf}
}
