% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elfgen.R
\name{elfgen}
\alias{elfgen}
\title{Generate Ecological Limit Function (ELF)}
\usage{
elfgen(
  watershed.df,
  quantile,
  breakpt,
  yaxis_thresh,
  xlabel = FALSE,
  ylabel = FALSE,
  plot_title = FALSE,
  break_var = "x_var"
)
}
\arguments{
\item{watershed.df}{A dataframe of sites with ecological and hydrologic data}

\item{quantile}{A specified value for the quantile of interest - 0.95 equals the 95th percentile}

\item{breakpt}{A breakpoint - either user-supplied fixed value or derived using elfgen breakpoint functions bkpt_pwit() or bkpt_ymax}

\item{yaxis_thresh}{Value used for specifying y-axis max limit}

\item{xlabel}{Used to overwrite default x-axis label}

\item{ylabel}{Used to overwrite default y-axis label}

\item{plot_title}{A plot title used to title the ggplot. If left as the
default (FALSE), the plot will be titled using the name of the HUC from
nhdPlus}

\item{break_var}{The name of the variable in watershed.df to be filtered for
by the breakpt, defaults to the expected name "x_var"}
}
\value{
Object containing plot image and dataframe of ELF statistics
}
\description{
Generate ELF models by supplying a dataframe of richness and stream size data (streamflow or drainage area), a quantile for evaluating the ecological limit, and a breakpoint threshold.
}
\examples{
\donttest{
# We don't run this example by R CMD check, because it takes >10s

watershed.df <- elfdata(watershed.code = '0208020104',
 ichthy.localpath = tempdir(), use_cache = FALSE)
breakpt <- 500
elfgen(
   "watershed.df" = watershed.df,
   "quantile" = 0.80,
   "breakpt" = breakpt,
   "xlabel" = "Mean Annual Flow (ft3/s)",
   "ylabel" = "Fish Species Richness"
   )
}
}
