% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egor-package.R
\docType{package}
\name{egor-package}
\alias{egor-package}
\title{R Package for importing and analyzing ego-centered-network data}
\description{
Tools for importing, analyzing and visualizing ego-centered network data. Supports several data formats, including the export formats of 'EgoNet', 'EgoWeb 2.0' and 'openeddi'. An interactive (shiny) app for the intuitive visualization of ego-centered networks is provided. Also included are procedures for creating and visualizing Clustered Graphs (Lerner 2008 \doi{10.1109/PACIFICVIS.2008.4475458}).
}
\details{
When analyzing ego-centered network data it is common to either
include or exclude data on ego. By default \code{egor} excludes ego for most
analytic and visual functions and offers to include ego with the argument
\code{include.ego}. In order for egor to automatically detect which ego-level
variables correspond to the alter-variables, the variables on the different
levels need to be named exactly the same. Alternatively the functions that
have an \code{include.ego} argument have additional arguments that allow to
specify the name of the ego-level variable in question.

For further information see
\href{https://egor.tillt.net/}{package webpage} or
\href{https://github.com/tilltnet/egor}{GitHub}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tilltnet/egor}
  \item \url{https://egor.tillt.net/}
  \item Report bugs at \url{https://github.com/tilltnet/egor/issues}
}

}
\author{
\strong{Maintainer}: Till Krenz \email{egor@tillt.net}

Authors:
\itemize{
  \item Pavel N. Krivitsky \email{pavel@statnet.org}
  \item Raffaele Vacca \email{r.vacca@ufl.edu}
  \item Michal Bojanowski \email{michal2992@gmail.com} (\href{https://orcid.org/0000-0001-7503-852X}{ORCID})
  \item Andreas Herz \email{herzand@uni-hildesheim.de}
}

Other contributors:
\itemize{
  \item Markus Gamper \email{m.gamper@uni-koeln.de} [contributor]
  \item Christopher McCarty \email{ufchris@ufl.edu} [contributor]
}

}
\keyword{internal}
