% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_traces.R
\name{number_of_traces}
\alias{number_of_traces}
\alias{number_of_traces.log}
\alias{number_of_traces.grouped_log}
\title{Number of Traces}
\usage{
number_of_traces(log)

\method{number_of_traces}{log}(log)

\method{number_of_traces}{grouped_log}(log)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}
}
\description{
Computes how many traces there are.

This metric provides two values, the absolute and relative number of traces that occur in the log.
The relative number shows expected number of traces needed to cover 100 cases.
}
\section{Methods (by class)}{
\itemize{
\item \code{number_of_traces(log)}: Number of traces in a \code{\link[bupaR]{log}}.

\item \code{number_of_traces(grouped_log)}: Number of traces in a \code{\link[bupaR]{grouped_log}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link[bupaR]{traces}}

Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{processing_time}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_structuredness}
