% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_presence.R
\name{activity_presence}
\alias{activity_presence}
\alias{activity_presence.eventlog}
\alias{activity_presence.grouped_eventlog}
\alias{activity_presence.activitylog}
\alias{activity_presence.grouped_activitylog}
\title{Metric: Activity Presence}
\usage{
activity_presence(log, sort = TRUE)

\method{activity_presence}{eventlog}(log, sort = TRUE)

\method{activity_presence}{grouped_eventlog}(log, sort = TRUE)

\method{activity_presence}{activitylog}(log, sort = TRUE)

\method{activity_presence}{grouped_activitylog}(log, sort = TRUE)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort output on count. Only for levels with frequency count output.}
}
\description{
Calculates for each activity type in what percentage of cases it is present.
}
\details{
An indication of variance can be the presence of the activities in the different cases. This metric shows for each activity the absolute
number of cases in which each activity occurs together with its relative presence.
}
\section{Methods (by class)}{
\itemize{
\item \code{activity_presence(eventlog)}: Compute activity presence for an \code{\link[bupaR]{eventlog}}.

\item \code{activity_presence(grouped_eventlog)}: Compute activity presence for a \code{\link[bupaR]{grouped_eventlog}}.

\item \code{activity_presence(activitylog)}: Compute activity presence for an \code{\link[bupaR]{activitylog}}.

\item \code{activity_presence(grouped_activitylog)}: Compute activity presence for a \code{\link[bupaR]{grouped_activitylog}}.

}}
\examples{
\dontrun{
data <- data.frame(case = rep("A",5),
activity_id = c("A","B","C","D","E"),
activity_instance_id = 1:5,
lifecycle_id = rep("complete",5),
timestamp = 1:5,
resource = rep("resource 1", 5))

log <- bupaR::eventlog(data,case_id = "case",
activity_id = "activity_id",
activity_instance_id = "activity_instance_id",
lifecycle_id = "lifecycle_id",
timestamp = "timestamp",
resource_id = "resource")

activity_presence(log)
}

}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{number_of_traces}()},
\code{\link{processing_time}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_structuredness}
