% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_util_fun.R
\name{num_equal}
\alias{num_equal}
\title{Test two numeric vectors for pairwise (near) equality}
\usage{
num_equal(x, y, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{1st numeric vector to compare (required, assumes a numeric vector).}

\item{y}{2nd numeric vector to compare (required, assumes a numeric vector).}

\item{tol}{Numeric tolerance value.
Default: \code{tol = .Machine$double.eps^0.5} 
(see \code{?.Machine} for details).}
}
\description{
\code{num_equal} tests if two numeric vectors \code{x} and \code{y} are pairwise equal 
(within a tolerance value `tol`).
}
\details{
\code{num_equal} verifies that \code{x} and \code{y} are numeric and 
then evaluates \code{abs(x - y) < tol}. 
Thus, \code{num_equal} provides a safer way to verify the (near) equality of numeric vectors than \code{==}   
(due to possible floating point effects).
}
\examples{
num_equal(2, sqrt(2)^2)

# Recycling: 
num_equal(c(2, 3), c(sqrt(2)^2, sqrt(3)^2, 4/2, 9/3))

# Contrast:
.1 == .3/3
num_equal(.1, .3/3)

# Contrast:
v <- c(.9 - .8, .8 - .7, .7 - .6, .6 - .5, 
       .5 - .4, .4 - .3, .3 - .2, .2 -.1, .1)
unique(v)
.1 == v
num_equal(.1, v)
 
}
\seealso{
\code{\link{is_equal}} function for generic vectors;
\code{\link{all.equal}} function of the R \strong{base} package;
\code{near} function of the \strong{dplyr} package.

Other numeric functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()}

Other utility functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_equal}()},
\code{\link{is_vect}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()}
}
\concept{numeric functions}
\concept{utility functions}
