% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{buildPML}
\alias{buildPML}
\title{Wrapper for phangorn::optim.pml}
\usage{
buildPML(
  clone,
  seq = "sequence",
  sub_model = "GTR",
  gamma = FALSE,
  asr = "seq",
  asr_thresh = 0.05,
  tree = NULL,
  data_type = "DNA",
  optNni = TRUE,
  optQ = TRUE,
  optEdge = TRUE,
  verbose = FALSE,
  resolve_random = TRUE,
  quiet = 0,
  rep = NULL,
  dir = NULL,
  id = NULL,
  asrp = FALSE
)
}
\arguments{
\item{clone}{\code{airrClone} object}

\item{seq}{sequence column in \code{airrClone} object}

\item{sub_model}{substitution model to use}

\item{gamma}{gamma site rate variation?}

\item{asr}{return sequence or probability matrix?}

\item{asr_thresh}{threshold for including a nucleotide as an alternative}

\item{tree}{fixed tree topology if desired.}

\item{data_type}{Are sequences DNA or AA?}

\item{optNni}{Optimize tree topology}

\item{optQ}{Optimize Q matrix}

\item{optEdge}{Optimize edge lengths}

\item{verbose}{Print error messages as they happen?}

\item{resolve_random}{randomly resolve polytomies?}

\item{quiet}{amount of rubbish to print to console}

\item{rep}{current bootstrap replicate (experimental)}

\item{dir}{A directory to save the codon table}

\item{id}{The identifier value}

\item{asrp}{Get the codon table?}
}
\value{
\code{phylo} object created by phangorn::optim.pml with nodes
         attribute containing reconstructed sequences.
}
\description{
Wrapper for phangorn::optim.pml
}
