% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{dock_view_plugins}
\alias{dock_view_plugins}
\alias{new_dock_view_plugin}
\alias{new_dock_view_plugin.add_tab}
\alias{new_dock_view_plugin.remove_tab}
\alias{new_add_tab_plugin}
\alias{new_remove_tab_plugin}
\title{Create dock view plugins}
\usage{
new_dock_view_plugin(type, ...)

\method{new_dock_view_plugin}{add_tab}(type, enable = FALSE, callback = NULL, ...)

\method{new_dock_view_plugin}{remove_tab}(type, enable = FALSE, callback = NULL, mode = "auto", ...)

new_add_tab_plugin(enable = FALSE, callback = NULL, ...)

new_remove_tab_plugin(enable = FALSE, callback = NULL, mode = "auto", ...)
}
\arguments{
\item{type}{Character string specifying the plugin type.}

\item{...}{Additional plugin configuration arguments.}

\item{enable}{Logical, whether the plugin functionality is enabled.}

\item{callback}{Optional JavaScript function. If \code{NULL} and \code{enable = TRUE},
a default callback is used.}

\item{mode}{For remove_tab plugins only. One of "auto" or "manual".}
}
\value{
A dock view plugin object of class \code{add_tab} or \code{remove_tab}, depending
on the choosen `type``.
}
\description{
Create plugins to enable additional functionality in dock view interfaces.
Currently supports "add_tab" and "remove_tab" plugins.
}
\examples{
# Add tab plugin
new_dock_view_plugin("add_tab", enable = TRUE)
new_add_tab_plugin(enable = TRUE)  # convenience function

# Remove tab plugin
new_dock_view_plugin("remove_tab", enable = TRUE, mode = "auto")
new_remove_tab_plugin(enable = TRUE, mode = "manual")  # convenience function

}
