#' @title Menhinick index
#'
#' @description Computes menhinick's index
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Menhinick index.
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' menhinick(Qesem_s$HU)
#'
#' @export
menhinick <- function(x){
  # x: is a vector of dimension S (spicies) with the numbers of observed
  #        individuals in each spicy. NA values are allowed
  x <- stats::na.omit(x)
  stopifnot(is.numeric(x))
  x <- ifelse(x==0, NA, x)
  x <- stats::na.omit(x)
  stopifnot(
    all(x >0),
    isTRUE(all.equal(x, round(x)))
  )
  return(length(x)/sqrt(sum(x)))
}
