% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdq_gev.R
\name{pgev}
\alias{pgev}
\alias{qgev}
\alias{dgev}
\title{Representations of the Generalized Extreme Value Distribution}
\usage{
pgev(q, location, scale, shape)

qgev(p, location, scale, shape)

dgev(x, location, scale, shape)
}
\arguments{
\item{location}{Location parameter; numeric vector.}

\item{scale}{Scale parameter; positive numeric vector.}

\item{shape}{Shape parameter; numeric vector.
This is also the extreme value index,
so that \code{shape > 0} is heavy tailed, and \code{shape < 0} is short-tailed.}

\item{p}{Vector of probabilities.}

\item{x, q}{Vector of quantiles.}
}
\value{
Vector of evaluated GEV distribution, with length
equal to the recycled lengths of \code{q}/\code{x}/\code{p}, \code{location}, \code{scale}, and
\code{shape}.
}
\description{
Representations of the Generalized Extreme Value Distribution
}
\examples{
pgev(1:10, 0, 1, 1)
dgev(1:10, 1:10, 2, 0)
qgev(1:9 / 10, 2, 10, -2)
}
