% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcomp-package.R
\name{availableComputations}
\alias{availableComputations}
\title{Return the currently available (implemented) computations}
\usage{
availableComputations()
}
\value{
a list with the components corresponding to a computation
\item{desc}{a textual description (25 chars at most)}
\item{definitionApp}{the name of a function that will fire up a shiny webapp
for defining the particular computation}
\item{workerApp}{the name of a function that will fire up a shiny webapp
for setting up a worker site for the particular computation}
\item{masterApp}{the name of a function that will fire up a shiny webapp
for setting up a master for the particular computation}
\item{makeDefinition}{the name of a function that will return a data frame
with appropriate fields needed to define the particular computation assuming
that they are populated in a global variable. This function is used by web
applications to construct a definition object based on inputs specified
by the users. Since the full information is often gathered incrementally by
several web applications, the inputs are set in a global variable and
therefore retrieved here using the function \code{getComputationInfo}
designed for the purpose}
\item{makeMaster}{a function that will construct a master object for the
computation given the definition and a logical flag indicating
if debugging is desired}
\item{makeWorker}{a function that will construct
a worker object for that computation given the definition and data}
}
\description{
The function \code{availableComputations} returns a list
of available computations with various components. The names of this list
(with no spaces) are unique canonical tags that are used throughout the
package to unambiguously refer to the type of computation; web applications
particularly rely on this list to instantiate objects. As more computations
are implemented, this list is augmented.
}
\examples{
availableComputations()
}
\seealso{
\code{\link[=getComputationInfo]{getComputationInfo()}}
}
