% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querycount.R
\name{HEQueryCountMaster}
\alias{HEQueryCountMaster}
\title{Create a homomorphic computation query count master object to employ worker objects generated by \code{\link[=HEQueryCountWorker]{HEQueryCountWorker()}}}
\description{
\code{HEQueryCountMaster} objects instantiate and run a distributed homomorphic query count computation; they're instantiated by non-cooperating parties (NCPs)
}
\seealso{
\code{\link[=HEQueryCountWorker]{HEQueryCountWorker()}} which goes hand-in-hand with this object
}
\section{Super class}{
\code{\link[distcomp:QueryCountMaster]{distcomp::QueryCountMaster}} -> \code{HEQueryCountMaster}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pubkey}}{the master's public key visible to everyone}

\item{\code{pubkey_bits}}{the number of bits in the public key (used for reconstructing public key remotely by serializing to character)}

\item{\code{pubkey_n}}{the \code{n} for the public key used for reconstructing public key remotely}

\item{\code{den}}{the denominator for rational arithmetic}

\item{\code{den_bits}}{the number of bits in the denominator used for reconstructing denominator remotely}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HEQueryCountMaster-new}{\code{HEQueryCountMaster$new()}}
\item \href{#method-HEQueryCountMaster-setParams}{\code{HEQueryCountMaster$setParams()}}
\item \href{#method-HEQueryCountMaster-kosher}{\code{HEQueryCountMaster$kosher()}}
\item \href{#method-HEQueryCountMaster-queryCount}{\code{HEQueryCountMaster$queryCount()}}
\item \href{#method-HEQueryCountMaster-cleanup}{\code{HEQueryCountMaster$cleanup()}}
\item \href{#method-HEQueryCountMaster-run}{\code{HEQueryCountMaster$run()}}
\item \href{#method-HEQueryCountMaster-clone}{\code{HEQueryCountMaster$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="distcomp" data-topic="QueryCountMaster" data-id="addSite"><a href='../../distcomp/html/QueryCountMaster.html#method-QueryCountMaster-addSite'><code>distcomp::QueryCountMaster$addSite()</code></a></span></li>
<li><span class="pkg-link" data-pkg="distcomp" data-topic="QueryCountMaster" data-id="getSites"><a href='../../distcomp/html/QueryCountMaster.html#method-QueryCountMaster-getSites'><code>distcomp::QueryCountMaster$getSites()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-new"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{HEQueryCountMaster} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$new(defn, partyNumber, debug = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{the computation definition}

\item{\code{partyNumber}}{the party number of the NCP that this object belongs to (1 or 2)}

\item{\code{debug}}{a flag for debugging, default \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{HEQueryCountMaster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-setParams"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-setParams}{}}}
\subsection{Method \code{setParams()}}{
Set some parameters of the \code{HEQueryCountMaster} object for homomorphic computations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$setParams(pubkey_bits, pubkey_n, den_bits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pubkey_bits}}{the number of bits in public key}

\item{\code{pubkey_n}}{the \code{n} for the public key}

\item{\code{den_bits}}{the number of bits in the denominator (power of 2) used in rational approximations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-kosher"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-kosher}{}}}
\subsection{Method \code{kosher()}}{
Check if inputs and state of object are sane. For future use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$kosher()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} or \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-queryCount"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-queryCount}{}}}
\subsection{Method \code{queryCount()}}{
Run the distributed query count, associate it with a token, and return the result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$queryCount(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{a token to use as key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the partial result as a list of encrypted items with components \code{int} and \code{frac}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-cleanup"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-cleanup}{}}}
\subsection{Method \code{cleanup()}}{
Cleanup the instance objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$cleanup()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-run"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-run}{}}}
\subsection{Method \code{run()}}{
Run the homomorphic encrypted distributed query count computation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$run(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{a token to use as key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the partial result as a list of encrypted items with components \code{int} and \code{frac}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountMaster-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountMaster-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountMaster$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
