% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.diffdf}
\alias{print.diffdf}
\title{Print diffdf objects}
\usage{
\method{print}{diffdf}(x, row_limit = 10, as_string = FALSE, file = NULL, ...)
}
\arguments{
\item{x}{A comparison object created by \code{diffdf()}.}

\item{row_limit}{Maximum number of rows to display in difference tables.
Use \code{NULL} to show all rows. Default is 10.}

\item{as_string}{Logical. If \code{TRUE}, returns the printed message as an R
character vector instead of printing to the console. Default is \code{FALSE}.}

\item{file}{A connection or a character string naming the file to print to. If
\code{NULL} (the default), output is printed to the console.}

\item{...}{Additional arguments (not used).}
}
\description{
Print a nicely formatted version of a diffdf object.
}
\examples{
x <- subset(iris, -Species)
x[1, 2] <- 5
COMPARE <- diffdf(iris, x)
print(COMPARE)
print(COMPARE, row_limit = 5)
\dontrun{
print(COMPARE, file = "output.txt")
}

}
