% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descsuppR-package.r
\name{buildDescrTbl.intern}
\alias{buildDescrTbl.intern}
\title{buildDescrTbl.intern}
\usage{
buildDescrTbl.intern(
  df,
  prmnames,
  prmunits,
  addFactorLevelsToNames = TRUE,
  extraLevels = NULL,
  includeNAs = FALSE,
  includeNonNAs = FALSE,
  orderedAsUnordered = FALSE,
  factorlevellimit = 14,
  show.minmax = TRUE,
  show.IQR = FALSE,
  sd_digits = "by_mean",
  descr_digits = 2,
  significant_digits = TRUE
)
}
\arguments{
\item{df}{data.frame containing the variables of which to calc the descriptive values}

\item{prmnames}{names of the variables in df (if needed to be overwritten)}

\item{prmunits}{units of the variables in df}

\item{addFactorLevelsToNames}{logical. if \code{TRUE} expand 'sex' to 'sex [m/w]'.  Defaults to \code{TRUE}.}

\item{extraLevels}{named list of lists.  Names have to be variable names.  Elements have to have to be named list of this form: \code{`some label` = list(idxvec = idxvec, display = logical)}.  Here \code{idxvec} needs to be a logical vector of length \code{nrow(df)} that specifies the affected rows.  If \code{display} is \code{TRUE} the number of affected rows will be shown under \code{some label}.}

\item{includeNAs}{boolean.  Include number of NAs in the output?  Currently only one of either \code{includeNonNAs} or \code{includeNAs} can be set to \code{TRUE}}

\item{includeNonNAs}{boolean.  Include number of not missing values (Non-NAs) in the output?  Currently only one of either \code{includeNonNAs} or \code{includeNAs} can be set to \code{TRUE}}

\item{orderedAsUnordered}{logical. treat ordered factors as
unordered factors?}

\item{factorlevellimit}{integer.  for factors with more than
\code{factorlevellimit} levels, not all levels are printed}

\item{show.minmax}{logical. if TRUE show minimum and maximum for numeric variables.  Defaults to \code{TRUE}.}

\item{show.IQR}{logical. if TRUE show 25\% and 75\% quantiles for numeric variables.  Defaults to \code{FALSE}.}

\item{sd_digits}{character.  one of c("by_mean", "fixed").  If 'by_mean', the number of decimal places of the standard deviation is limited by the number of decimal places of the mean.}

\item{descr_digits}{integer. Number of digits for formatting of descriptive values. Defaults to 2.}

\item{significant_digits}{boolean.  if TRUE, the number of significant digits of is given by descr_digits. Otherwise the number of decimal places is fixed.}
}
\value{
matrix with descriptive values
}
\description{
Internal wrapper around calc_descr_matrix
}
\author{
Andreas Leha
}
