% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{fit_weibull_plot}
\alias{fit_weibull_plot}
\alias{adjWeibull}
\title{Fit and Plot Three-Parameter Weibull Distribution with Confidence Bands}
\usage{
fit_weibull_plot(
  x,
  amplitude = 10,
  shape = 2,
  plot = TRUE,
  show_ci = TRUE,
  ci_level = 0.95,
  ci_method = "delta",
  n_boot = 1000,
  main = NULL,
  title.col = "black",
  mid = TRUE,
  line.col = "blue",
  ci.col = "lightblue",
  ci.alpha = 0.3,
  legendPos = "topright",
  lowLim = NULL,
  ymax = NULL,
  bg = "aliceblue",
  method = "mle",
  ties_method = "cheng_amin",
  cex.axis = 0.6,
  cex.lab = 0.8,
  las = 1,
  xlab = "Diameter class (cm)",
  ylab = "Relative frequency (\%)",
  cex.legend = 1,
  ...
)

adjWeibull(
  x,
  amplitude = 10,
  shape = 2,
  plot = TRUE,
  show_ci = TRUE,
  ci_level = 0.95,
  ci_method = "delta",
  n_boot = 1000,
  main = NULL,
  title.col = "black",
  mid = TRUE,
  line.col = "blue",
  ci.col = "lightblue",
  ci.alpha = 0.3,
  legendPos = "topright",
  lowLim = NULL,
  ymax = NULL,
  bg = "aliceblue",
  method = "mle",
  ties_method = "cheng_amin",
  cex.axis = 0.6,
  cex.lab = 0.8,
  las = 1,
  xlab = "Diameter class (cm)",
  ylab = "Relative frequency (\%)",
  cex.legend = 1,
  ...
)
}
\arguments{
\item{x}{numeric vector of diameter observations (typically tree diameters in cm).}

\item{amplitude}{numeric bin width for histogram (default: 10).}

\item{shape}{numeric initial value for shape parameter (default: 2).}

\item{plot}{logical; if TRUE, produces a histogram with fitted curve (default: TRUE).}

\item{show_ci}{logical; if TRUE, displays confidence bands around fitted curve
(default: TRUE). Only applicable when plot = TRUE and standard errors are available.}

\item{ci_level}{numeric confidence level for bands (default: 0.95).}

\item{ci_method}{character string for CI computation: "delta" (delta method using vcov),
"bootstrap" (parametric bootstrap), or "both" (default: "delta").}

\item{n_boot}{integer number of bootstrap samples (default: 1000). Only used if
ci_method is "bootstrap" or "both".}

\item{main}{character string for plot title (default: NULL).}

\item{title.col}{color for legend title (default: "black").}

\item{mid}{logical; if TRUE, curve is drawn from min to max of bin midpoints;
if FALSE, from min to max of bin breaks (default: TRUE).}

\item{line.col}{color for fitted curve (default: "blue").}

\item{ci.col}{color for confidence bands (default: "lightblue").}

\item{ci.alpha}{numeric transparency for confidence bands (default: 0.3).}

\item{legendPos}{position of legend (default: "topright").}

\item{lowLim}{numeric lower limit for histogram breaks (default: NULL, uses min(x)).}

\item{ymax}{numeric upper limit for y-axis (default: NULL, auto-computed).}

\item{bg}{background color for legend box (default: "aliceblue").}

\item{method}{character string specifying estimation method. Options:
"mle" (Maximum Likelihood - default), "mps" (Maximum Product Spacing),
"mom" (Method of Moments).}

\item{ties_method}{character string for ties correction in MPS: "cheng_amin", "none",
or "cheng_stephens" (default: "cheng_amin"). Only used when method = "mps".}

\item{cex.axis}{numeric character expansion factor for axis annotation (default: 0.6).}

\item{cex.lab}{numeric character expansion factor for axis labels (default: 0.8).}

\item{las}{numeric orientation of axis labels (default: 1).}

\item{xlab}{character string for x-axis label (default: "Diameter class (cm)").}

\item{ylab}{character string for y-axis label (default: "Relative frequency (\%)" ).}

\item{cex.legend}{numeric character expansion factor for legend (default: 1).}

\item{...}{additional graphical parameters passed to \code{\link{plot}}.}
}
\value{
A list (invisibly) containing:
\item{estimate}{Named vector of parameter estimates (shape, scale, location)}
\item{se}{Standard errors (NULL if unavailable or method doesn't support it)}
\item{vcov}{Variance-covariance matrix (NULL if unavailable)}
\item{ci}{Confidence intervals for parameters at specified level (NULL if unavailable)}
\item{measures}{Named vector of goodness-of-fit statistics (KS statistic, p-value, AIC, BIC)}
\item{convergence}{Integer convergence code (0 = successful)}
\item{method}{Character string of estimation method used}
\item{ci_method}{Character string of confidence interval method used}
\item{ci_level}{Numeric confidence level used}
\item{note}{Character string with interpretation note for KS test}
}
\description{
Fits a three-parameter Weibull distribution to diameter data and optionally
visualizes the fit with a histogram, fitted density curve, and confidence bands.
}
\examples{
# Simulate tree diameter data
set.seed(123)
diameters <- rweibull3(100, shape = 2.5, scale = 25, loc = 10)

# Fit with confidence bands
fit1 <- fit_weibull_plot(diameters, amplitude = 5, show_ci = TRUE)

# Fit without confidence bands
fit2 <- fit_weibull_plot(diameters, amplitude = 5, show_ci = FALSE)

# Use bootstrap confidence bands
fit3 <- fit_weibull_plot(diameters,
  amplitude = 5,
  ci_method = "bootstrap", n_boot = 500
)
}
\seealso{
\code{\link{fit_dist}}
}
