% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_brlen.R
\name{min_brlen}
\alias{min_brlen}
\title{A function to report the smallest tip-to-tip distances in a phylogenetic tree}
\usage{
min_brlen(tree, n = 5, verbose = TRUE)
}
\arguments{
\item{tree}{A path to tree file in Newick format, or a phylogenetic tree object of class \link[ape:read.tree]{phylo}.}

\item{n}{Number of distances to report (default = 5).}

\item{verbose}{Logical of whether to print the result to screen (default = TRUE).}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}
}
\description{
\code{min_brlen()} returns a table of smallest tip-to-tip distances in a phylogenetic tree.
}
\details{
\code{min_brlen()} tabulates the smallest tip-to-tip distances in a phylogenetic tree
using \link[ape:cophenetic.phylo]{cophenetic.phylo} and prints a table to screen.
This is useful when excluding identical or near-identical haplotypes
using the '--minbr' parameter in mPTP.
}
\examples{

# estimate minimum branch length from raxml tree
min_brlen(ape::as.phylo(geophagus_raxml), n = 5)

}
\author{
Rupert A. Collins
}
