% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_dri_survey.R
\name{format_dri_survey}
\alias{format_dri_survey}
\title{Format DRI survey}
\usage{
format_dri_survey(
  survey_info = list(type = NA_character_, order = NA_integer_, statement =
    NA_character_, name = NA_character_, scale_max = NA_integer_, q_method = NA)
)
}
\arguments{
\item{survey_info}{survey information needed to format DRI survey}
}
\value{
A list of survey info, including \code{name}, \code{considerations}
data, \code{policies} data, \code{scale_max} or the upper bound of
Likert-scale survey questions, and \code{q_method} which flags whether the
survey uses Q methodology
}
\description{
\code{format_dri_survey} helps transform raw survey data into
useful objects for further manipulation with \code{deliberr}
}
\examples{
dri_survey <- format_dri_survey(surveys[surveys$name == "acp", ])

dri_survey$name
dri_survey$considerations

}
\seealso{
\link{surveys} for raw survey data formatting
}
