% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sharing.R
\name{Share}
\alias{Share}
\title{Share a shareable object with a particular user.}
\usage{
Share(object, username, role = "default", canShare = NULL)
}
\arguments{
\item{object}{object. The shared object to inspect access for.}

\item{username}{character. The name of the user to share the object with.}

\item{role}{character. The role (access level) to give that user. See \code{SharingRole}.}

\item{canShare}{logical. Is the user allowed to further reshare?}
}
\description{
See \code{SharingRole} for more details on available access levels that can be granted
to a user. Set \code{role} to \code{NULL} to revoke access to a particular user.
}
\examples{
\dontrun{
 dataStoreId <- "5c1303269300d900016b41a7"
 dataStore <- GetDataStore(dataStoreId)
 # Grant access to a particular user.
 Share(dataStore, "foo@foo.com")
 # Grant access in a Read Only role.
 Share(dataStore, "foo@foo.com", role = SharingRole$ReadOnly)
 # Revoke access
 Share(dataStore, "foo@foo.com", role = NULL)
}
}
