% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_fix_meta_id_dups.R
\name{prep_fix_meta_id_dups}
\alias{prep_fix_meta_id_dups}
\title{Fix metadata duplicates}
\usage{
prep_fix_meta_id_dups(
  meta_data_segment = "segment_level",
  meta_data_dataframe = "dataframe_level",
  item_level = "item_level",
  meta_data = item_level,
  meta_data_v2,
  segment_level,
  dataframe_level
)
}
\arguments{
\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} the data frame that contains the
metadata for the data frame level}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{segment_level}{\link{data.frame} alias for \code{meta_data_segment}}

\item{dataframe_level}{\link{data.frame} alias for \code{meta_data_dataframe}}
}
\value{
\link{meta_data}
}
\description{
if \link{VAR_NAMES} have duplicates, maybe, it's because of ID-vars assigned
to different study segments multiple times (they should be in one "intro"-
segment, only), which is not the intended use of \code{STUDY_SEGMENT}.
Naturally, they will be part of more than one data-frame, so
this would also qualify for a dump duplicate, only, which can safely be
removed. Only ID-vars are by default assumed to have such duplicates in item
level metadata allowed.
}
\examples{
\dontrun{
il <- prep_get_data_frame("item_level")
il <- rbind(il, il)
il$STUDY_SEGMENT[2] <- "X"
il2 <- prep_fix_meta_id_dups(meta_data_v2 = "meta_data_v2", item_level = il)
il2$STUDY_SEGMENT
il$STUDY_SEGMENT[3] <- "X"
il3 <- prep_fix_meta_id_dups(meta_data_v2 = "meta_data_v2", item_level = il)
il3$STUDY_SEGMENT
}
}
