% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.ld.r
\name{gl.filter.ld}
\alias{gl.filter.ld}
\title{Filters loci based on linkage disequilibrium (LD)}
\usage{
gl.filter.ld(
  x,
  ld.report,
  threshold = 0.2,
  pop.limit = ceiling(nPop(x)/2),
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{ld.report}{Output from function \code{\link{gl.report.ld.map}} 
[required].}

\item{threshold}{Threshold value above which loci will be removed
[default 0.2].}

\item{pop.limit}{Minimum number of populations in which LD should be more
than the threshold for a locus to be filtered out.
The default value is half of the populations [default ceiling(nPop(x)/2)].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
The reduced genlight object.
}
\description{
This function uses the statistic set in the parameter \code{stat.keep} from 
function \code{\link{gl.report.ld.map}} to choose the SNP to keep when two 
SNPs are in LD. When a SNP is selected to be filtered out in each pairwise 
comparison, the function stores its  name in a list. In subsequent pairwise
 comparisons, if the SNP is already in the list, the other SNP will be kept.
}
\seealso{
\code{\link{gl.report.ld.map}}

Other matched filter: 
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.hamming}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.overshoot}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.secondaries}()}
}
\author{
Custodian: Luis Mijangos -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
\concept{matched filter}
