% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_smoothing_cluster.R
\name{smoothing_cluster}
\alias{smoothing_cluster}
\title{Smoothing by clustering (k-means)}
\usage{
smoothing_cluster(n)
}
\arguments{
\item{n}{number of bins}
}
\value{
returns an object of class \code{smoothing_cluster}
}
\description{
Quantize a numeric vector into \code{n} levels using k‑means on the values and
replace each value by its cluster mean (vector quantization).
}
\examples{
data(iris)
obj <- smoothing_cluster(n = 2)
obj <- fit(obj, iris$Sepal.Length)
sl.bi <- transform(obj, iris$Sepal.Length)
table(sl.bi)
obj$interval

entro <- evaluate(obj, as.factor(names(sl.bi)), iris$Species)
entro$entropy
}
\references{
MacQueen, J. (1967). Some Methods for classification and Analysis of Multivariate Observations.
}
