% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_mcmc_trace}
\alias{plot_mcmc_trace}
\alias{plot_mcmc_marginal}
\alias{plot_mcmc_auto}
\title{Plot MCMC Chains for Drift Diffusion Model Parameters}
\usage{
plot_mcmc_trace(
  chains,
  col_palette = grDevices::rainbow,
  col_chains = NULL,
  which_prms = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL
)

plot_mcmc_marginal(
  chains,
  col_line = NULL,
  col_shade = NULL,
  which_prms = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL
)

plot_mcmc_auto(
  chains,
  lags = 1:30,
  col_line = NULL,
  which_prms = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  type = NULL,
  main = NULL
)
}
\arguments{
\item{chains}{an array of MCMC samples with three dimensions
(parameters × chains × iterations; see also \code{\link[=plot.mcmc_dm]{plot.mcmc_dm()}}).
This argument is not optional and will be provided by
\code{\link[=plot.mcmc_dm]{plot.mcmc_dm()}}.}

\item{col_palette}{a function to generate a color palette for chains
(default is \link[grDevices:palettes]{grDevices::rainbow}). Must be callable like this
\code{col_palette(n)}.}

\item{col_chains}{a character vector, defining colors(s) to override
\code{col_palette} for chain lines. Can be a single value or a vector matching
the number of chains. Recycled if necessary to match the number of chains.}

\item{which_prms}{a regular expression (string), used to select a subset
of parameters to plot. For example, \code{"^v"} would match all parameters
starting with \code{v}. See also the examples in \code{\link[=plot.mcmc_dm]{plot.mcmc_dm()}}.}

\item{xlab, ylab}{character vector(s), specifying axis labels for each panel.
Recycled if necessary to match the number of plots being generated.}

\item{xlim, ylim}{list(s), containing length-2 numeric vectors specifying
x- and y-axis limits, respectively. Recycled if necessary to match the
number of plots being generated.}

\item{col_line}{a character vector, defining color(s) for the line outlines
in the density plots. Can be a single value or a vector matching the number
of parameters to plot. Recycled if necessary to match the number of
parameters being plotted.}

\item{col_shade}{a character vector, defining color(s) for the shaded
areas in the density plots. Can be a single value or a vector matching
the number of parameters to plot. Recycled if necessary to match the number
of parameters being plotted.}

\item{lags}{a numeric vector, giving the lags at which to calculate
autocorrelation (see also \code{\link[coda:autocorr.diag]{coda::autocorr.diag()}} and \code{\link[coda:autocorr]{coda::autocorr()}}).}

\item{type}{a character, specifying how autocorrelations shall be displayed.
Defaults to "h" (see the \code{type} argument of \code{\link[base:plot]{base::plot()}}). Recycled if
necessary to match the number of parameters being plotted.}

\item{main}{character vector, specifying the labels above each
autocorrelation plot. Defaults to parameter labels. Recycled if
necessary to match the number of parameters being plotted.}
}
\value{
These functions are called for their side effects (producing plots).
They return \code{NULL} invisibly.
}
\description{
The functions provide visualizations of MCMC results obtained for
\code{\link[=drift_dm]{drift_dm()}} objects. Users won't call the functions directly.
Instead, they are called via \code{\link[=plot.mcmc_dm]{plot.mcmc_dm()}}, and the
following documentation helps to define optional arguments that can be
passed on via  \code{...}.
}
\details{
\itemize{
\item \code{plot_mcmc_trace()} plots one panel per parameter, with lines for each
chain showing how values evolve over iterations. This is useful for
diagnosing convergence and mixing.
\item \code{plot_mcmc_marginal()} plots smoothed marginal posterior densities
collapsed over chains and iterations for each parameter, useful for
inspecting posterior distributions.
\item \code{plot_mcmc_auto()} plots the autocorrelation among samples as function
of \code{lags}.
}
}
\seealso{
\code{\link[=plot.mcmc_dm]{plot.mcmc_dm()}}
}
\keyword{internal}
