% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.drift_dm}
\alias{plot.drift_dm}
\title{Plot Components of a Drift Diffusion Model}
\usage{
\method{plot}{drift_dm}(x, ..., conds = NULL, col = NULL, xlim = NULL, bundle_plots = TRUE)
}
\arguments{
\item{x}{an object of class \link{drift_dm}}

\item{...}{additional graphical arguments passed to plotting functions.
See \code{\link[=set_default_arguments]{set_default_arguments()}} for the full list of supported
options.}

\item{conds}{a character vector specifying the conditions to plot.
Defaults to all available conditions.}

\item{col}{a character vector specifying colors for each condition. If a
single color is provided, it is repeated for all conditions.}

\item{xlim}{a numeric vector of length 2, specifying the x-axis limits.}

\item{bundle_plots}{logical, indicating whether to display separate panels
in a single plot layout (\code{FALSE}), or to plot them separately (\code{TRUE}).}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
This function generates plots for all components of a drift diffusion model
(DDM), such as drift rate, boundary, and starting condition. Each component
is plotted against the time or evidence space, allowing for visual inspection
of the model's behavior across different conditions.
}
\details{
The \code{plot.drift_dm} function provides an overview of key DDM components,
which include:
\itemize{
\item \code{mu_fun}: Drift rate over time.
\item \code{mu_int_fun}: Integrated drift rate over time (if required by the
specified \code{solver} of the model).
\item \code{x_fun}: Starting condition as a density across evidence values.
\item \code{b_fun}: Boundary values over time.
\item \code{dt_b_fun}: Derivative of the boundary function over time.
\item \code{nt_fun}: Non-decision time as a density over time.
}
}
\examples{
# plot the component functions of the Ratcliff DDM
plot(ratcliff_dm())
plot(ratcliff_dm(var_non_dec = TRUE))
# Note: the variability in the drift rate for the Ratcliff DDM
# is not plotted! This is because it is not actually stored as a component
# function.

# plot the component functions of the DMC model
plot(dmc_dm(), col = c("green", "red"))

}
