% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.delta_funs}
\alias{plot.delta_funs}
\title{Plot Delta Functions}
\usage{
\method{plot}{delta_funs}(
  x,
  ...,
  id = NULL,
  conds = NULL,
  dv = NULL,
  col = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "RT [s]",
  ylab = expression(Delta),
  interval_obs = TRUE,
  interval_pred = TRUE
)
}
\arguments{
\item{x}{an object of \code{type = "delta_funs"}, typically returned by
\code{\link[=calc_stats]{calc_stats()}}.}

\item{...}{additional graphical arguments passed to plotting functions.
See \code{\link[=set_default_arguments]{set_default_arguments()}} for the full list of supported
options.}

\item{id}{a numeric or character, specifying the ID of a single participant
to plot. If \code{length(id) > 1}, \code{plot.cafs()} is called recursively for
each entry. Each \code{id} must match an entry in the \code{ID} column of \code{x}.}

\item{conds}{a character vector specifying the conditions to plot.
Defaults to all available conditions.}

\item{dv}{a character vector indicating the delta function(s) to plot.
Defaults to all columns in \code{x} that begin with \code{"Delta_"}.}

\item{col}{a character vector specifying colors for each condition. If a
single color is provided, it is repeated for all conditions.}

\item{xlim}{a numeric vector of length 2, specifying the x-axis limits.}

\item{ylim}{a numeric vector of length 2, specifying the y-axis limits.}

\item{xlab, ylab}{character strings for the x- and y-axis labels.}

\item{interval_obs, interval_pred}{logicals; if \code{TRUE} and \code{x} contains a
column named \code{Estimate}, error bars for observed data and shaded contours
for predicted data are drawn, respectively.}
}
\value{
Returns \code{NULL} invisibly. The function is called for its side effect of
generating a plot.
}
\description{
Visualizes delta functions for observed and/or predicted data. This is useful
for assessing model fit or exploring the model behavior
}
\details{
If \code{x} contains multiple \code{ID}s and no specific \code{id} is provided, the
function aggregates across participants before plotting.

Observed delta functions are shown as points, and predicted delta functions
as lines. When \code{interval_obs = TRUE} or \code{interval_pred = TRUE} and the input
includes interval estimates (i.e., the column \code{Estimate} exists), the plot
includes error bars for observed data and shaded contours for model
predictions.

Colors, symbols, and line styles can be customized via \code{...}.
}
\examples{
# Example 1: Model predictions only ---------------------------------------
a_model <- dmc_dm()
deltas <- calc_stats(
  a_model,
  type = "delta_funs",
  minuends = "incomp",
  subtrahends = "comp"
)
plot(deltas)
plot(deltas, col = "black", lty = 2, xlim = c(0.2, 0.65))

# Example 2: Observed and predicted data ----------------------------------
obs_data(a_model) <- dmc_synth_data
deltas <- calc_stats(
  a_model,
  type = "delta_funs",
  minuends = "incomp",
  subtrahends = "comp"
)
plot(deltas)

# Example 3: Observed data only -------------------------------------------
deltas <- calc_stats(
  dmc_synth_data,
  type = "delta_funs",
  minuends = "incomp",
  subtrahends = "comp"
)
plot(deltas)

# Example 4: Observed data with intervals ---------------------------------
deltas <- calc_stats(
  dmc_synth_data,
  type = "delta_funs",
  minuends = "incomp",
  subtrahends = "comp",
  resample = TRUE
)
plot(deltas)

}
