% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extended_s3_methods.R
\name{nobs.drift_dm}
\alias{nobs.drift_dm}
\title{Get the Number of Observations for a drift_dm Object}
\usage{
\method{nobs}{drift_dm}(object, ...)
}
\arguments{
\item{object}{a \link{drift_dm} object, which potentially contains the
observed data in \code{object$obs_data}.}

\item{...}{additional arguments}
}
\value{
An integer representing the total number of observations across
all conditions in \code{object$obs_data}.  If \code{obs_data} doesn't exist, the
function returns 0
}
\description{
This method retrieves the total number of observations in the \code{obs_data}
list of a \code{drift_dm} object.
}
\details{
The function iterates over each element in \code{object$obs_data}, counts
the entries in each nested component, and returns the cumulative sum as the
total observation count.

It was written to provide an \code{nobs} method for calculating the log-likelihood
(\link{logLik}), AIC (\link[stats:AIC]{stats::AIC}), and BIC (\link[stats:AIC]{stats::BIC}) statistics
for objects of type \link{drift_dm}.
}
\examples{
# get a pre-built model and data set for demonstration purpose
a_model <- dmc_dm()
obs_data(a_model) <- dmc_synth_data

# then get the number of observations by accessing the model
nobs(a_model)

# same number of observations as in the original data set
nrow(dmc_synth_data)

}
