% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_network}
\alias{po_network}
\title{Network}
\usage{
po_network(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
Appends nodes arguments to a network-specific 'htmlwidgets' object
}
\description{
Draw a network graph showing relationships between entities.
Requires an igraph object with nodes (vertices) and links (edges).
Node size can represent counts or other metrics.
}
\examples{
if (interactive()) {
  trade_network <- d3po::trade[d3po::trade$year == 2023L, ]
  trade_network <- aggregate(
    trade ~
      reporter_iso + partner_iso + reporter_continent + partner_continent,
    data = trade_network, FUN = sum
  )

  # subset to 10 largest connection per reporter country
  trade_network <- do.call(
    rbind,
    lapply(
      split(trade_network, trade_network$reporter_iso),
      function(df) head(df[order(-df$trade), ], 10)
    )
  )

  # Create vertex (node) attributes for coloring and sizing
  # Get unique countries with their continents and trade volumes
  vertices <- unique(rbind(
    data.frame(
      name = trade_network$reporter_iso,
      continent = trade_network$reporter_continent,
      stringsAsFactors = FALSE
    ),
    data.frame(
      name = trade_network$partner_iso,
      continent = trade_network$partner_continent,
      stringsAsFactors = FALSE
    )
  ))

  # Remove duplicates
  vertices <- vertices[!duplicated(vertices$name), ]

  # Calculate total trade volume per country (as reporter)
  trade_volume <- aggregate(trade ~ reporter_iso, data = trade_network, FUN = sum)
  colnames(trade_volume) <- c("name", "trade_volume")

  # Merge trade volume with vertices
  vertices <- merge(vertices, trade_volume, by = "name", all.x = TRUE)
  vertices$trade_volume[is.na(vertices$trade_volume)] <- 0

  # Assign colors to continents
  # my_pal <- tintin::tintin_pal(option = "The Blue Lotus")(7)
  # [1] "#328699" "#5C5756" "#9A5D35" "#9F8F6F" "#A52B33" "#D58253" "#D81A1E"

  my_pal <- c("#328699", "#5C5756", "#9A5D35", "#9F8F6F", "#A52B33", "#D58253", "#D81A1E")

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  # Add color column based on continent
  vertices$color <- my_pal[vertices$continent]

  # Create igraph object with vertex attributes
  g <- graph_from_data_frame(trade_network, directed = TRUE, vertices = vertices)

  # Create the network visualization
  d3po(g, width = 800, height = 600) \%>\%
    po_network(daes(size = trade_volume, color = color, layout = "fr")) \%>\%
    po_labels(title = "Trade Network by Country in 2023")
}

}
