% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_joint_box}
\alias{plot_joint_box}
\title{Circular Boxplot of Turn Angles and Step Lengths}
\usage{
plot_joint_box(
  traj = NULL,
  theta = NULL,
  x = NULL,
  levels = 5,
  marginal_lin = NULL,
  spacing = 0.3,
  legend_pos = "right"
)
}
\arguments{
\item{traj}{\link[base]{data.frame} containing the trajectory produced by e.g.
\code{\link{traj_sim}()}. It must contain
 the columns \code{traj$angle} and \code{traj$steplength}.}

\item{theta}{(alternatively) \link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable) or "circular" component of pseudo-observations.}

\item{x}{(alternatively) \link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable) or "linear" component of pseudo-observations.}

\item{levels}{\link[base]{integer} value between 1 and 15, the number of
quantiles into which the step lengths are split.}

\item{marginal_lin}{named \link[base]{list} (for parametric estimates) or
a '\code{\link[stats]{density}}' object (for kernel density estimates).
The output of function \code{\link{fit_steplength}()} can be used here directly for
both cases. If \code{marginal_lin} is specified, the limits of the quantiles of the step lengths
 are determined from that distribution instead of from the data specified with
\code{traj$steplength} or \code{x}.}

\item{spacing}{\link[base]{numeric} value between 0 and 10 determining the
spacing between the boxplots.}

\item{legend_pos}{\link[base]{character} string denoting the position of the legend (limits
of the step length quantiles). Either \code{"left"}, \code{"right"}, \code{"top"}, or
\code{"bottom"}}
}
\value{
A '\code{\link[ggplot2]{ggplot}}' object, the circular boxplot.
}
\description{
This function produces circular boxplots (a '\code{\link[ggplot2]{ggplot}}' object)
of the turn angles corresponding to specific quantiles of the step lengths.
}
\details{
The step lengths are split into quantiles. For each quantile a boxplot of the
corresponding turn angles is produced and wrapped around the circle.
The turn angle values are plotted
as scatter plot overlaying the boxplot. Outliers are plotted in red.
The median of the turn angles is defined as the center of the shortest arc
that connects all points. The length of the whiskers is 1.5 times the interquartile range.

You can either specify \code{traj} or the angels (\code{theta})
and step lengths (\code{x}).
If entered "by hand", the named list describing the marginal linear distribution
(for \code{marginal_lin}) must contain 2 entries:
\enumerate{
   \item{\code{name}:
a \link[base]{character} string denoting the name of the linear distribution,
i.e. the name of its
   distribution function without the "p",
  e.g. "norm" for normal distribution.}
   \item{\code{coef}: a named list containing the parameters of the distribution
   given in \code{"name"}.}
}
}
\examples{
set.seed(1234)

traj <- traj_sim(100,
  copula = cyl_rect_combine(copula::frankCopula(6)),
  marginal_circ = list(name= "vonmises", coef=list(0, 2)),
  marginal_lin = list(name = "weibull", coef=list(shape=3))
)

plot1 <- plot_joint_box(traj)
plot2 <- plot_joint_box(traj,
  marginal_lin=list(name = "weibull", coef=list(shape=3))
)

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{plot_cop_scat}()}, \code{\link{plot_track}()},
\code{\link{plot_joint_circ}()}, \code{\link{plot_cop_surf}()}.
}
